/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.editors;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import org.eclipse.core.resources.IFile;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.io.Utils;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.AxisSelection;

class SelectedFile {
    boolean use = true;
    boolean canUseData = false;
    boolean hasMV = false;
    IntegerDataset i;
    File f;
    DataHolder h;
    IMetaData m;
    ILazyDataset d;
    Serializable mv;
    List<AxisSelection> asl;
    private static final String INDEX = "index";

    public SelectedFile(int n, IFile iFile) {
        this.f = new File(iFile.getLocationURI());
        if (this.f == null || !this.f.canRead()) {
            throw new IllegalArgumentException("File '" + iFile.getName() + "' does not exist or can not be read");
        }
        this.setIndex(n);
    }

    public SelectedFile(int n, File file) {
        this.f = file;
        if (this.f == null || !this.f.canRead()) {
            throw new IllegalArgumentException("File '" + file.getName() + "' does not exist or can not be read");
        }
        this.setIndex(n);
    }

    public SelectedFile(int n, String string) {
        this.f = new File(string);
        if (this.f == null || !this.f.canRead()) {
            throw new IllegalArgumentException("File '" + string + "' does not exist or can not be read");
        }
        this.setIndex(n);
    }

    public String getAbsolutePath() {
        return this.f.getAbsolutePath();
    }

    public String getName() {
        return this.f.getName();
    }

    public String toString() {
        if (this.mv == null) {
            return null;
        }
        return this.mv.toString();
    }

    public void setIndex(int n) {
        this.i = new IntegerDataset(new int[]{n}, null);
        this.i.setName(INDEX);
    }

    public String getIndex() {
        return this.i.getString(new int[]{0});
    }

    public boolean doUse() {
        return this.use;
    }

    public void setUse(boolean bl) {
        this.use = bl;
    }

    public boolean isDataOK() {
        return this.canUseData;
    }

    public void setDataOK(boolean bl) {
        this.canUseData = bl;
    }

    public boolean hasMetaValue() {
        return this.hasMV;
    }

    public boolean hasMetadata() {
        return this.m != null;
    }

    public boolean hasDataHolder() {
        return this.h != null;
    }

    public boolean hasData() {
        return this.d != null;
    }

    public void setDataHolder(DataHolder dataHolder) {
        this.h = dataHolder;
        if (this.h != null) {
            this.m = this.h.getMetadata();
        } else {
            this.d = null;
        }
    }

    public void setData(String string) {
        if (this.h.contains(string)) {
            this.d = this.h.getLazyDataset(string);
        } else {
            int n = this.h.size();
            this.d = null;
            int n2 = 0;
            while (n2 < n) {
                ILazyDataset iLazyDataset = this.h.getLazyDataset(n2);
                if (string.equals(iLazyDataset.getName())) {
                    this.d = iLazyDataset;
                    break;
                }
                ++n2;
            }
        }
    }

    public ILazyDataset getData() {
        return this.d;
    }

    public ILazyDataset getAxis(String string) {
        return this.h != null ? this.h.getLazyDataset(string) : null;
    }

    public ILazyDataset getMetaValue() {
        if (!this.hasMV) {
            return null;
        }
        if (this.mv instanceof ILazyDataset) {
            return (ILazyDataset)this.mv;
        }
        return AbstractDataset.array((Object)this.mv);
    }

    public void setMetaValueAsIndex() {
        this.hasMV = true;
        this.mv = this.i;
    }

    public void setMetaValue(String string) {
        if (this.m == null) {
            this.hasMV = false;
            return;
        }
        try {
            this.mv = this.m.getMetaValue(string);
            if (this.mv instanceof String) {
                this.mv = Utils.parseValue((String)((String)((Object)this.mv)));
                if (this.mv != null) {
                    AbstractDataset abstractDataset = AbstractDataset.array((Object)this.mv);
                    abstractDataset.setName(string);
                    this.mv = abstractDataset;
                }
            }
            if (this.mv == null && this.h != null) {
                this.mv = this.h.getDataset(string);
            }
        }
        catch (Exception exception) {}
        this.hasMV = this.mv != null;
    }

    public void setAxisSelections(List<AxisSelection> list) {
        this.asl = list;
    }

    public List<AxisSelection> getAxisSelections() {
        return this.asl;
    }

    public boolean hasAxisSelections() {
        return this.asl != null;
    }
}

