/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.editors;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import uk.ac.diamond.scisoft.analysis.rcp.explorers.AbstractExplorer;
import uk.ac.diamond.scisoft.analysis.rcp.explorers.SRSExplorer;
import uk.ac.diamond.scisoft.analysis.rcp.navigator.srs.SRSTreeData;
import uk.ac.gda.common.rcp.util.EclipseUtils;

public class SRSEditor
extends EditorPart {
    private SRSExplorer srsxp;
    private File file;
    private ISelectionListener selectionListener;

    public void doSave(IProgressMonitor iProgressMonitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        this.file = EclipseUtils.getFile((IEditorInput)iEditorInput);
        if (this.file == null || !this.file.exists()) {
            throw new PartInitException("Input is not a file or file does not exist");
        }
        if (!this.file.canRead()) {
            throw new PartInitException("Cannot read file (are permissions correct?)");
        }
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.setInput(iEditorInput);
        this.setPartName(iEditorInput.getName());
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite composite) {
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        this.srsxp = new SRSExplorer(composite, iWorkbenchPartSite, null);
        try {
            this.srsxp.loadFileAndDisplay(this.file.getPath(), null);
        }
        catch (Exception exception) {
            return;
        }
        iWorkbenchPartSite.setSelectionProvider((ISelectionProvider)this.srsxp);
        this.registerSelectionListener();
    }

    public void setFocus() {
        this.srsxp.setFocus();
    }

    private void registerSelectionListener() {
        ISelectionService iSelectionService = this.getSite().getWorkbenchWindow().getSelectionService();
        if (iSelectionService == null) {
            throw new IllegalStateException("Cannot acquire the selection service!");
        }
        this.selectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
                IStructuredSelection iStructuredSelection;
                Object object;
                if (iSelection instanceof IStructuredSelection && !iSelection.isEmpty() && (object = (iStructuredSelection = (IStructuredSelection)iSelection).getFirstElement()) instanceof SRSTreeData) {
                    String string;
                    SRSTreeData sRSTreeData = (SRSTreeData)object;
                    String string2 = sRSTreeData.getFile().getLocation().toString();
                    String[] stringArray = string2.split("/");
                    if ((string2 = stringArray[stringArray.length - 1]).equals(string = SRSEditor.this.getSite().getPart().getTitle())) {
                        SRSEditor.this.update(iWorkbenchPart, sRSTreeData);
                    }
                }
            }
        };
        iSelectionService.addSelectionListener(this.selectionListener);
    }

    private void unregisterSelectionListener() {
        ISelectionService iSelectionService = this.getSite().getWorkbenchWindow().getSelectionService();
        if (iSelectionService == null) {
            throw new IllegalStateException("Cannot acquire the selection service!");
        }
        iSelectionService.removeSelectionListener(this.selectionListener);
    }

    public void dispose() {
        this.unregisterSelectionListener();
        super.dispose();
    }

    public static Class<? extends AbstractExplorer> getExplorerClass() {
        return SRSExplorer.class;
    }

    public void update(IWorkbenchPart iWorkbenchPart, SRSTreeData sRSTreeData) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                while (Display.getDefault().readAndDispatch()) {
                }
                SRSEditor.this.srsxp.forceFocus();
            }
        });
        TableViewer tableViewer = this.srsxp.getViewer();
        int n = 0;
        while (n < tableViewer.getTable().getItemCount()) {
            String string = tableViewer.getTable().getItem(n).getText();
            if (string.equals(sRSTreeData.getName())) {
                tableViewer.getTable().setSelection(n);
                this.srsxp.selectItemSelection();
                break;
            }
            ++n;
        }
        EclipseUtils.getActivePage().activate(iWorkbenchPart);
    }
}

