/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.editors;

import java.util.Iterator;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.Page;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Attribute;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Dataset;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Group;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Node;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5NodeLink;

public class HDF5ValuePage
extends Page
implements ISelectionListener,
IPartListener {
    private static Logger logger = LoggerFactory.getLogger(HDF5ValuePage.class);
    protected CLabel label;
    protected SourceViewer sourceViewer;
    protected StructuredSelection lastSelection;
    protected Composite container;

    public void createControl(Composite composite) {
        this.container = new Composite(composite, 0);
        this.container.setLayout((Layout)new GridLayout(1, false));
        GridLayout gridLayout = (GridLayout)this.container.getLayout();
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.container.setBackground(composite.getDisplay().getSystemColor(1));
        this.label = new CLabel(this.container, 16384);
        this.label.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.label.setBackground(composite.getDisplay().getSystemColor(1));
        this.sourceViewer = new SourceViewer(this.container, null, 776);
        this.sourceViewer.setEditable(false);
        this.sourceViewer.getTextWidget().setLayoutData((Object)new GridData(4, 4, true, true));
        this.getSite().getPage().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        this.getSite().getPage().addPartListener((IPartListener)this);
        try {
            this.updateSelection(HDF5ValuePage.getActivePage().getSelection());
        }
        catch (Throwable throwable) {}
    }

    public Control getControl() {
        return this.container;
    }

    public void setFocus() {
        this.sourceViewer.getTextWidget().setFocus();
    }

    public void dispose() {
        super.dispose();
        this.getSite().getPage().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        this.getSite().getPage().removePartListener((IPartListener)this);
        this.lastSelection = null;
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        try {
            this.updateSelection(iSelection);
        }
        catch (Exception exception) {
            logger.error("Cannot update value", (Throwable)exception);
        }
    }

    protected void updateSelection(ISelection iSelection) {
        if (iSelection instanceof StructuredSelection) {
            this.lastSelection = (StructuredSelection)iSelection;
            Object object = this.lastSelection.getFirstElement();
            this.updateObjectSelection(object);
            this.sourceViewer.refresh();
            this.label.getParent().layout(new Control[]{this.label, this.sourceViewer.getTextWidget()});
            return;
        }
        this.clear();
    }

    private void clear() {
        this.label.setText("");
        this.sourceViewer.getTextWidget().setText("");
    }

    public void partActivated(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart == this) {
            try {
                this.updateSelection((ISelection)this.lastSelection);
            }
            catch (Throwable throwable) {}
        }
    }

    public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
    }

    public void partClosed(IWorkbenchPart iWorkbenchPart) {
    }

    public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
    }

    public void partOpened(IWorkbenchPart iWorkbenchPart) {
    }

    public void updateObjectSelection(Object object) {
        if (object instanceof HDF5NodeLink) {
            HDF5NodeLink hDF5NodeLink = (HDF5NodeLink)object;
            this.createH5Value(hDF5NodeLink);
        }
    }

    private void createH5Value(HDF5NodeLink hDF5NodeLink) {
        StringBuilder stringBuilder;
        HDF5Dataset hDF5Dataset;
        if (hDF5NodeLink.isDestinationADataset()) {
            hDF5Dataset = (HDF5Dataset)hDF5NodeLink.getDestination();
            stringBuilder = new StringBuilder();
            this.label.setText("Dataset name of '" + hDF5NodeLink.getName() + "' value:");
            stringBuilder.append(hDF5Dataset.toString());
            this.appendAttributes((HDF5Node)hDF5Dataset, stringBuilder);
            this.sourceViewer.getTextWidget().setText(stringBuilder.toString());
        }
        if (hDF5NodeLink.isDestinationAGroup()) {
            hDF5Dataset = (HDF5Group)hDF5NodeLink.getDestination();
            this.label.setText("Group name of '" + hDF5NodeLink.getName() + "' children:");
            stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            Iterator iterator = hDF5Dataset.getNodeNameIterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                stringBuilder.append(string);
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append("]\n");
            this.appendAttributes((HDF5Node)hDF5Dataset, stringBuilder);
            this.sourceViewer.getTextWidget().setText(stringBuilder.toString());
        }
    }

    private void appendAttributes(HDF5Node hDF5Node, StringBuilder stringBuilder) {
        stringBuilder.append("\n\nAttributes:\n");
        Iterator iterator = hDF5Node.getAttributeIterator();
        while (iterator.hasNext()) {
            HDF5Attribute hDF5Attribute = (HDF5Attribute)iterator.next();
            stringBuilder.append(hDF5Attribute.getName());
            stringBuilder.append(" = ");
            stringBuilder.append(hDF5Attribute.getValue().toString());
            stringBuilder.append("\n");
        }
    }

    private static IWorkbenchPage getActivePage() {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        if (iWorkbench == null) {
            return null;
        }
        IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            return null;
        }
        return iWorkbenchWindow.getActivePage();
    }
}

