/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.editors;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5File;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5NodeLink;
import uk.ac.diamond.scisoft.analysis.rcp.editors.HDF5ValuePage;
import uk.ac.diamond.scisoft.analysis.rcp.explorers.AbstractExplorer;
import uk.ac.diamond.scisoft.analysis.rcp.hdf5.HDF5TreeExplorer;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.DatasetSelection;
import uk.ac.gda.common.rcp.util.EclipseUtils;

public class HDF5TreeEditor
extends EditorPart
implements IPageChangedListener,
IReusableEditor {
    private HDF5TreeExplorer hdfxp;
    private File file;
    private ISelectionListener selectionListener;
    public static final String ID = "uk.ac.diamond.scisoft.analysis.rcp.editors.HDF5TreeEditor";
    private static final Logger logger = LoggerFactory.getLogger(HDF5TreeEditor.class);

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        this.file = EclipseUtils.getFile((IEditorInput)iEditorInput);
        if (this.file == null || !this.file.exists()) {
            logger.warn("File does not exist: {}", (Object)iEditorInput.getName());
            throw new PartInitException("Input is not a file or file does not exist");
        }
        if (!this.file.canRead()) {
            logger.warn("Cannot read file: {}", (Object)iEditorInput.getName());
            throw new PartInitException("Cannot read file (are permissions correct?)");
        }
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.setInput(iEditorInput);
    }

    public void setInput(IEditorInput iEditorInput) {
        super.setInput(iEditorInput);
    }

    protected boolean loadHDF5Tree() {
        if (this.getHDF5Tree() != null) {
            return true;
        }
        String string = this.file.getAbsolutePath();
        try {
            if (this.hdfxp != null) {
                this.hdfxp.loadFileAndDisplay(string, null);
                return true;
            }
        }
        catch (Exception exception) {
            if (exception.getCause() != null) {
                logger.warn("Could not load NeXus file {}: {}", (Object)string, (Object)exception.getCause().getMessage());
            }
            logger.warn("Could not load NeXus file {}: {}", (Object)string, (Object)exception.getMessage());
        }
        return false;
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite composite) {
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        this.hdfxp = new HDF5TreeExplorer(composite, iWorkbenchPartSite, null);
        if (!this.loadHDF5Tree()) {
            return;
        }
        iWorkbenchPartSite.setSelectionProvider((ISelectionProvider)this.hdfxp);
        this.setPartName(this.file.getName());
    }

    public void pageChanged(PageChangedEvent pageChangedEvent) {
        if (pageChangedEvent.getSelectedPage() == this) {
            this.loadHDF5Tree();
        }
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
    }

    public void doSaveAs() {
    }

    public void setFocus() {
        this.hdfxp.setFocus();
    }

    public void expandAll() {
        this.hdfxp.expandAll();
    }

    public void dispose() {
        this.file = null;
        if (this.hdfxp != null) {
            this.hdfxp.dispose();
        }
        super.dispose();
    }

    public HDF5TreeExplorer getHDF5TreeExplorer() {
        return this.hdfxp;
    }

    public HDF5File getHDF5Tree() {
        if (this.hdfxp == null) {
            return null;
        }
        return this.hdfxp.getHDF5Tree();
    }

    public static Class<? extends AbstractExplorer> getExplorerClass() {
        return HDF5TreeExplorer.class;
    }

    private void registerSelectionListener() {
        ISelectionService iSelectionService = this.getSite().getWorkbenchWindow().getSelectionService();
        if (iSelectionService == null) {
            throw new IllegalStateException("Cannot acquire the selection service!");
        }
        this.selectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
                IStructuredSelection iStructuredSelection;
                Object object;
                if (iSelection instanceof IStructuredSelection && !iSelection.isEmpty() && (object = (iStructuredSelection = (IStructuredSelection)iSelection).getFirstElement()) instanceof HDF5NodeLink) {
                    HDF5NodeLink hDF5NodeLink = (HDF5NodeLink)object;
                    String[] stringArray = hDF5NodeLink.getFile().getFilename().split("/");
                    String string = "";
                    if (stringArray.length > 0) {
                        string = stringArray[stringArray.length - 1];
                    }
                    if (string.equals(HDF5TreeEditor.this.getSite().getPart().getTitle())) {
                        HDF5TreeEditor.this.update(iWorkbenchPart, hDF5NodeLink, iStructuredSelection);
                    }
                }
            }
        };
        iSelectionService.addSelectionListener(this.selectionListener);
    }

    private void unregisterSelectionListener() {
        if (this.selectionListener == null) {
            return;
        }
        ISelectionService iSelectionService = this.getSite().getWorkbenchWindow().getSelectionService();
        if (iSelectionService == null) {
            throw new IllegalStateException("Cannot acquire the selection service!");
        }
        iSelectionService.removeSelectionListener(this.selectionListener);
    }

    public void update(IWorkbenchPart iWorkbenchPart, HDF5NodeLink hDF5NodeLink, IStructuredSelection iStructuredSelection) {
        block9: {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    while (Display.getDefault().readAndDispatch()) {
                    }
                    HDF5TreeEditor.this.hdfxp.forceFocus();
                }
            });
            Cursor cursor = this.hdfxp.getCursor();
            Cursor cursor2 = this.hdfxp.getDisplay().getSystemCursor(1);
            if (cursor2 != null) {
                this.hdfxp.setCursor(cursor2);
            }
            try {
                try {
                    TreePath treePath = new TreePath(iStructuredSelection.toArray());
                    this.hdfxp.expandToLevel(treePath, 2);
                    this.hdfxp.setSelection((ISelection)iStructuredSelection);
                    this.hdfxp.selectHDF5Node(hDF5NodeLink, DatasetSelection.InspectorType.LINE);
                }
                catch (Exception exception) {
                    logger.error("Error processing selection: {}", (Object)exception.getMessage());
                    if (cursor2 != null) {
                        this.hdfxp.setCursor(cursor);
                    }
                    break block9;
                }
            }
            catch (Throwable throwable) {
                if (cursor2 != null) {
                    this.hdfxp.setCursor(cursor);
                }
                throw throwable;
            }
            if (cursor2 != null) {
                this.hdfxp.setCursor(cursor);
            }
        }
        EclipseUtils.getActivePage().activate(iWorkbenchPart);
    }

    public Object getAdapter(Class clazz) {
        if (clazz == IContentProvider.class) {
            return new HDF5ValuePage();
        }
        return super.getAdapter(clazz);
    }
}

