/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.editors;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.AggregateDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.editors.CompareFilesEditorInput;
import uk.ac.diamond.scisoft.analysis.rcp.editors.SelectedFile;
import uk.ac.diamond.scisoft.analysis.rcp.explorers.AbstractExplorer;
import uk.ac.diamond.scisoft.analysis.rcp.explorers.MetadataSelection;
import uk.ac.diamond.scisoft.analysis.rcp.hdf5.HDF5Selection;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.AxisChoice;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.AxisSelection;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.DatasetSelection;

public class CompareFilesEditor
extends EditorPart
implements ISelectionChangedListener,
ISelectionProvider {
    private static final Logger logger = LoggerFactory.getLogger(CompareFilesEditor.class);
    public static final String ID = "uk.ac.diamond.scisoft.analysis.rcp.editors.CompareFilesEditor";
    private SashForm sashComp;
    private List<SelectedFile> fileList;
    private TableViewer viewer;
    private Class<? extends AbstractExplorer> expClass = null;
    private AbstractExplorer explorer;
    private String firstFileName;
    private boolean useRowIndexAsValue = true;
    private DatasetSelection currentDatasetSelection;
    private DatasetSelection multipleSelection;
    private TableColumn valueColumn;
    private FileDialog fileDialog;
    private String editorName;
    private static final String VALUE_DEFAULT_TEXT = "Value";
    private List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();

    public static IEditorInput createComparesFilesEditorInput(IStructuredSelection iStructuredSelection) {
        return new CompareFilesEditorInput(iStructuredSelection);
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        if (!(iEditorInput instanceof CompareFilesEditorInput)) {
            throw new PartInitException("Invalid input for comparison");
        }
        this.setSite((IWorkbenchPartSite)iEditorSite);
        try {
            this.setInput(iEditorInput);
        }
        catch (Exception exception) {
            throw new PartInitException("Invalid input for comparison", (Throwable)exception);
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void setInput(IEditorInput var1_1) {
        if (!(var1_1 instanceof CompareFilesEditorInput)) {
            return;
        }
        super.setInput(var1_1);
        var2_2 = (CompareFilesEditorInput)var1_1;
        this.fileList = new ArrayList<SelectedFile>();
        var3_3 = 0;
        var4_4 = 0;
        while (var4_4 < var2_2.list.length) {
            if ((var5_5 = var2_2.list[var4_4++]) instanceof IFile) {
                var6_6 /* !! */  = (IFile)var5_5;
                try {
                    this.fileList.add(new SelectedFile(var3_3, var6_6 /* !! */ ));
                    ++var3_3;
                    break;
                }
                catch (IllegalArgumentException var7_8) {
                    CompareFilesEditor.logger.warn("Problem with selection: ", (Throwable)var7_8);
                    continue;
                }
            }
            if (!(var5_5 instanceof File)) continue;
            var6_6 /* !! */  = (File)var5_5;
            try {
                this.fileList.add(new SelectedFile(var3_3, (File)var6_6 /* !! */ ));
                ++var3_3;
                break;
            }
            catch (IllegalArgumentException var7_9) {
                CompareFilesEditor.logger.warn("Problem with selection: ", (Throwable)var7_9);
            }
        }
        if (var3_3 == 0) {
            return;
        }
        this.firstFileName = this.fileList.get(0).getAbsolutePath();
        var5_5 = CompareFilesEditor.getEditorCls(this.firstFileName);
        this.editorName = null;
        for (IFile var6_6 : var5_5) {
            try {
                var8_10 = Class.forName((String)var6_6 /* !! */ );
                var9_13 = var8_10.getMethod("getExplorerClass", new Class[0]);
                this.editorName = var6_6 /* !! */ ;
                this.expClass = (Class)var9_13.invoke(null, new Object[0]);
                break;
            }
            catch (Exception v0) {}
        }
        if (this.expClass != null) ** GOTO lbl72
        throw new IllegalArgumentException("No explorer available to read " + this.firstFileName);
lbl-1000:
        // 1 sources

        {
            if ((var6_6 /* !! */  = var2_2.list[var4_4++]) instanceof IFile) {
                var7_7 /* !! */  = var6_6 /* !! */ ;
                try {
                    var8_10 = new SelectedFile(var3_3, var7_7 /* !! */ );
                    var9_13 = var8_10.getAbsolutePath();
                    if (!CompareFilesEditor.getEditorCls((String)var9_13).contains(this.editorName)) {
                        CompareFilesEditor.logger.warn("Editor cannot read file: {}", var9_13);
                    }
                    this.fileList.add((SelectedFile)var8_10);
                    ++var3_3;
                }
                catch (IllegalArgumentException var8_11) {
                    CompareFilesEditor.logger.warn("Problem with selection: ", (Throwable)var8_11);
                }
                continue;
            }
            if (!(var6_6 /* !! */  instanceof File)) continue;
            var7_7 /* !! */  = (File)var6_6 /* !! */ ;
            try {
                var8_10 = new SelectedFile(var3_3, (File)var7_7 /* !! */ );
                var9_13 = var8_10.getAbsolutePath();
                if (!CompareFilesEditor.getEditorCls((String)var9_13).contains(this.editorName)) {
                    CompareFilesEditor.logger.warn("Editor cannot read file: {}", var9_13);
                }
                this.fileList.add((SelectedFile)var8_10);
                ++var3_3;
                continue;
            }
            catch (IllegalArgumentException var8_12) {
                CompareFilesEditor.logger.warn("Problem with selection: ", (Throwable)var8_12);
            }
lbl72:
            // 6 sources

            ** while (var4_4 < var2_2.list.length)
        }
lbl73:
        // 1 sources

        var2_2.list.length;
        this.setPartName(var1_1.getToolTipText());
    }

    public boolean addFile(String string) {
        return this.addFile(string, this.fileList.size());
    }

    private boolean addFile(String string, int n) {
        if (string == null) {
            return false;
        }
        SelectedFile selectedFile = this.createSelectedFile(string);
        if (selectedFile == null) {
            return false;
        }
        if (n == 0) {
            logger.warn("Cannot add file to top of order");
            n = 1;
        }
        this.fileList.add(n, selectedFile);
        int n2 = 0;
        for (SelectedFile selectedFile2 : this.fileList) {
            selectedFile2.setIndex(n2++);
        }
        if (this.currentDatasetSelection != null) {
            this.changeSelection();
        } else {
            this.viewer.refresh();
        }
        return true;
    }

    private SelectedFile createSelectedFile(String string) {
        SelectedFile selectedFile;
        block3: {
            try {
                selectedFile = new SelectedFile(this.fileList.size(), string);
                String string2 = selectedFile.getAbsolutePath();
                if (CompareFilesEditor.getEditorCls(string2).contains(this.editorName)) break block3;
                logger.warn("Editor cannot read file: {}", (Object)string2);
                return null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.warn("Problem with new file: ", (Throwable)illegalArgumentException);
                return null;
            }
        }
        return selectedFile;
    }

    public void addFileUsingFileDialog() {
        String string;
        if (this.fileDialog == null) {
            this.fileDialog = new FileDialog(this.getSite().getShell(), 4096);
        }
        if ((string = this.fileDialog.open()) != null) {
            this.addFile(string);
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite composite) {
        Display display = composite.getDisplay();
        this.sashComp = new SashForm(composite, 512);
        this.sashComp.setLayout((Layout)new FillLayout(512));
        this.viewer = new TableViewer((Composite)this.sashComp, 512);
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.viewer, 0);
        TableColumn tableColumn = tableViewerColumn.getColumn();
        tableColumn.setText("Use");
        tableColumn.setToolTipText("Toggle to use in dataset inspector (a yellow background indicates a missing or incompatible dataset)");
        tableColumn.setWidth(40);
        tableColumn.setMoveable(false);
        tableViewerColumn.setEditingSupport((EditingSupport)new CFEditingSupport(this.viewer, Column.TICK, null));
        tableViewerColumn.setLabelProvider((CellLabelProvider)new TickLabelProvider(display));
        tableViewerColumn = new TableViewerColumn(this.viewer, 0);
        tableColumn = tableViewerColumn.getColumn();
        tableColumn.setText("File name");
        tableColumn.setToolTipText("Name of resource");
        tableColumn.setWidth(100);
        tableColumn.setMoveable(false);
        tableViewerColumn.setEditingSupport((EditingSupport)new CFEditingSupport(this.viewer, Column.PATH, null));
        tableViewerColumn.setLabelProvider((CellLabelProvider)new PathLabelProvider(display));
        tableViewerColumn = new TableViewerColumn(this.viewer, 0);
        this.valueColumn = tableViewerColumn.getColumn();
        this.valueColumn.setText(VALUE_DEFAULT_TEXT);
        this.valueColumn.setToolTipText("Value of resource (a yellow background indicates a missing value)");
        this.valueColumn.setWidth(40);
        this.valueColumn.setMoveable(false);
        tableViewerColumn.setEditingSupport((EditingSupport)new CFEditingSupport(this.viewer, Column.VALUE, null));
        tableViewerColumn.setLabelProvider((CellLabelProvider)new ValueLabelProvider(display));
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object object) {
                return CompareFilesEditor.this.fileList == null ? null : CompareFilesEditor.this.fileList.toArray();
            }
        });
        this.viewer.addDropSupport(3, new Transfer[]{FileTransfer.getInstance()}, (DropTargetListener)new CFDropAdapter((Viewer)this.viewer));
        final Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        final Menu menu = new Menu((Decorations)this.sashComp.getShell(), 8);
        menu.addListener(22, new Listener(){

            public void handleEvent(Event event) {
                MenuItem[] menuItemArray = menu.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem menuItem = menuItemArray[n2];
                    menuItem.setEnabled(!CompareFilesEditor.this.useRowIndexAsValue);
                    ++n2;
                }
            }
        });
        MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setText("Use row index as value");
        menuItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CompareFilesEditor.this.useRowIndexAsValue = true;
                CompareFilesEditor.this.valueColumn.setText(CompareFilesEditor.VALUE_DEFAULT_TEXT);
                CompareFilesEditor.this.viewer.refresh();
                CompareFilesEditor.this.changeSelection();
            }
        });
        table.setMenu(menu);
        final Menu menu2 = null;
        table.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                Point point = CompareFilesEditor.this.sashComp.getDisplay().map(null, (Control)table, new Point(event.x, event.y));
                Rectangle rectangle = table.getClientArea();
                boolean bl = rectangle.y <= point.y && point.y < rectangle.y + table.getHeaderHeight();
                table.setMenu(bl ? menu : menu2);
            }
        });
        if (this.fileList != null) {
            this.viewer.setInput(this.fileList);
            TableColumn[] tableColumnArray = this.viewer.getTable().getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn tableColumn2 = tableColumnArray[n2];
                tableColumn2.pack();
                ++n2;
            }
        }
        try {
            this.explorer = this.expClass.getConstructor(Composite.class, IWorkbenchPartSite.class, ISelectionChangedListener.class).newInstance(new Object[]{this.sashComp, this.getSite(), this});
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Cannot make explorer", exception);
        }
        try {
            this.explorer.loadFileAndDisplay(this.firstFileName, null);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Explorer cannot load file", exception);
        }
        this.explorer.addSelectionChangedListener(this);
        this.getSite().setSelectionProvider((ISelectionProvider)this);
    }

    private void changeSelection() {
        if (this.currentDatasetSelection != null) {
            this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.currentDatasetSelection));
        }
    }

    public static List<String> getEditorCls(String string) {
        IConfigurationElement[] iConfigurationElementArray;
        IEditorDescriptor iEditorDescriptor;
        IEditorRegistry iEditorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        IConfigurationElement iConfigurationElement = iEditorRegistry.getEditors(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        IConfigurationElement iConfigurationElement2 = iConfigurationElement;
        int n = ((IEditorDescriptor[])iConfigurationElement2).length;
        int n2 = 0;
        while (n2 < n) {
            iEditorDescriptor = iConfigurationElement2[n2];
            if (iEditorDescriptor.isInternal()) {
                arrayList.add(iEditorDescriptor.getId());
            }
            ++n2;
        }
        iEditorDescriptor = new ArrayList();
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui.editors");
        IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
        int n3 = iConfigurationElementArray.length;
        int n4 = 0;
        while (n4 < n3) {
            iConfigurationElement2 = iConfigurationElementArray2[n4];
            String string2 = iConfigurationElement2.getAttribute("id");
            String string3 = iConfigurationElement2.getAttribute("class");
            if (string2 != null && string3 != null && arrayList.contains(string2)) {
                iEditorDescriptor.add(string3);
            }
            ++n4;
        }
        return iEditorDescriptor;
    }

    public void setFocus() {
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        Object object;
        Object object2;
        ISelection iSelection = selectionChangedEvent.getSelection();
        if (iSelection instanceof MetadataSelection) {
            object2 = ((MetadataSelection)iSelection).getPathname();
            this.loadMetaValues((String)object2);
            this.useRowIndexAsValue = false;
            this.valueColumn.setText((String)object2);
        } else if (iSelection instanceof DatasetSelection) {
            this.currentDatasetSelection = (DatasetSelection)iSelection;
            if (this.currentDatasetSelection instanceof HDF5Selection) {
                object2 = ((HDF5Selection)this.currentDatasetSelection).getNode();
                object = ((String)object2).substring(0, ((String)object2).lastIndexOf("/") + 1);
            } else {
                object2 = this.currentDatasetSelection.getFirstElement().getName();
                int n = ((String)object2).indexOf(":");
                if (n >= 0) {
                    object2 = ((String)object2).substring(n + 1);
                }
                object = null;
            }
            logger.debug("Selected data = {}", object2);
            this.loadDatasets((String)object2);
            if (this.useRowIndexAsValue) {
                this.setMetaValuesAsIndexes();
            }
            this.loadAxisSelections(this.currentDatasetSelection.getAxes(), (String)object);
        } else {
            return;
        }
        if (this.currentDatasetSelection != null) {
            DatasetSelection.InspectorType inspectorType;
            Object object3;
            object2 = new ArrayList();
            object = new ArrayList();
            ArrayList<List<AxisSelection>> arrayList = new ArrayList<List<AxisSelection>>();
            for (SelectedFile selectedFile : this.fileList) {
                if (!selectedFile.doUse() || !selectedFile.hasData() || !selectedFile.hasMetaValue()) continue;
                selectedFile.setDataOK(true);
                object2.add(selectedFile.getData());
                object.add(selectedFile.getMetaValue());
                arrayList.add(new ArrayList<AxisSelection>(selectedFile.getAxisSelections()));
            }
            boolean bl = true;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                object3 = (ILazyDataset)iterator.next();
                if (object3.getSize() <= 1) continue;
                bl = false;
                break;
            }
            if (object2.size() == 0) {
                logger.warn("No datasets found or selected");
                return;
            }
            object3 = AggregateDataset.calcShapes((boolean)bl, (ILazyDataset[])object2.toArray(new ILazyDataset[0]));
            int n = ((ILazyDataset)object3).length - 1;
            ILazyDataset iLazyDataset = object3[0];
            int n2 = bl ? 0 : -1;
            int n3 = this.fileList.size() - 1;
            while (n3 >= 0 && n > 0) {
                SelectedFile selectedFile = this.fileList.get(n3);
                if (selectedFile.doUse() && selectedFile.hasData() && selectedFile.hasMetaValue()) {
                    boolean bl2 = AbstractDataset.areShapesCompatible((int[])iLazyDataset, (int[])object3[n], (int)n2);
                    selectedFile.setDataOK(bl2);
                    if (!bl2) {
                        object2.remove(n);
                        object.remove(n);
                        arrayList.remove(n);
                    }
                    --n;
                }
                --n3;
            }
            switch (this.currentDatasetSelection.getType()) {
                case IMAGE: {
                    inspectorType = DatasetSelection.InspectorType.MULTIIMAGES;
                    break;
                }
                default: {
                    inspectorType = DatasetSelection.InspectorType.LINESTACK;
                }
            }
            this.setSelection((ISelection)CompareFilesEditor.createSelection(inspectorType, bl, (List<ILazyDataset>)object2, (List<ILazyDataset>)object, arrayList));
        }
        this.viewer.refresh();
    }

    private void setMetaValuesAsIndexes() {
        for (SelectedFile selectedFile : this.fileList) {
            selectedFile.setMetaValueAsIndex();
        }
    }

    private void loadMetaValues(String string) {
        logger.debug("Selected metadata = {}", (Object)string);
        for (SelectedFile selectedFile : this.fileList) {
            if (!selectedFile.hasMetadata() && !selectedFile.hasDataHolder()) {
                try {
                    DataHolder dataHolder = this.explorer.loadFile(selectedFile.getAbsolutePath(), null);
                    selectedFile.setDataHolder(dataHolder);
                }
                catch (Exception exception) {
                    continue;
                }
            }
            selectedFile.setMetaValue(string);
        }
    }

    private void loadDatasets(String string) {
        for (SelectedFile selectedFile : this.fileList) {
            if (!selectedFile.hasDataHolder()) {
                try {
                    DataHolder dataHolder = this.explorer.loadFile(selectedFile.getAbsolutePath(), null);
                    if (dataHolder == null) continue;
                    selectedFile.setDataHolder(dataHolder);
                }
                catch (Exception exception) {
                    continue;
                }
            }
            selectedFile.setData(string);
        }
    }

    private void loadAxisSelections(List<AxisSelection> list, String string) {
        boolean bl = true;
        ArrayList<AxisSelection> arrayList = new ArrayList<AxisSelection>();
        for (AxisSelection object2 : list) {
            arrayList.add(object2.clone());
        }
        for (SelectedFile selectedFile : this.fileList) {
            if (!selectedFile.doUse() || !selectedFile.hasData() || !this.useRowIndexAsValue && !selectedFile.hasMetaValue()) continue;
            if (bl) {
                bl = false;
                selectedFile.setAxisSelections(arrayList);
                continue;
            }
            selectedFile.setAxisSelections(this.makeAxes(arrayList, selectedFile, string));
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            AxisSelection axisSelection;
            arrayList2.clear();
            arrayList2.addAll(list.get(n2).getNames());
            for (SelectedFile selectedFile : this.fileList) {
                if (!selectedFile.hasData()) continue;
                axisSelection = selectedFile.getAxisSelections().get(n2);
                for (String string2 : axisSelection) {
                    if (axisSelection.getAxis(string2) != null) continue;
                    logger.warn("Removing choice {} as it is missing in {}", (Object)string2, (Object)selectedFile.getName());
                    arrayList2.remove(string2);
                }
            }
            for (SelectedFile selectedFile : this.fileList) {
                if (!selectedFile.hasData()) continue;
                axisSelection = selectedFile.getAxisSelections().get(n2);
                for (String string2 : axisSelection) {
                    if (arrayList2.contains(string2)) continue;
                    axisSelection.removeChoice(string2);
                }
            }
            ++n2;
        }
    }

    private List<AxisSelection> makeAxes(List<AxisSelection> list, SelectedFile selectedFile, String string) {
        ArrayList<AxisSelection> arrayList = new ArrayList<AxisSelection>();
        for (AxisSelection axisSelection : list) {
            AxisSelection axisSelection2 = axisSelection.clone();
            int n = 0;
            int n2 = axisSelection2.size();
            while (n < n2) {
                AxisChoice axisChoice = axisSelection2.getAxis(n);
                String string2 = axisChoice.getName();
                ILazyDataset iLazyDataset = selectedFile.getAxis(string != null ? String.valueOf(string) + string2 : string2);
                if (iLazyDataset == null && string2.startsWith("dim:")) {
                    iLazyDataset = axisChoice.getValues().clone();
                }
                axisChoice.setValues(iLazyDataset);
                ++n;
            }
            arrayList.add(axisSelection2);
        }
        return arrayList;
    }

    public static DatasetSelection createSelection(DatasetSelection.InspectorType inspectorType, List<ILazyDataset> list, List<ILazyDataset> list2, List<List<AxisSelection>> list3) {
        boolean bl = true;
        for (ILazyDataset iLazyDataset : list2) {
            if (iLazyDataset.getSize() <= 1) continue;
            bl = false;
            break;
        }
        return CompareFilesEditor.createSelection(inspectorType, bl, list, list2, list3);
    }

    /*
     * WARNING - void declaration
     */
    public static DatasetSelection createSelection(DatasetSelection.InspectorType inspectorType, boolean bl, List<ILazyDataset> list, List<ILazyDataset> list2, List<List<AxisSelection>> list3) {
        AggregateDataset aggregateDataset;
        Object object;
        AggregateDataset aggregateDataset2 = new AggregateDataset(bl, list.toArray(new ILazyDataset[0]));
        ILazyDataset[] iLazyDatasetArray = list2.toArray(new ILazyDataset[0]);
        ILazyDataset iLazyDataset = iLazyDatasetArray[0];
        if (iLazyDataset instanceof AbstractDataset && iLazyDataset.getRank() == 1) {
            void list4;
            object = new AbstractDataset[iLazyDatasetArray.length];
            boolean n = false;
            while (list4 < iLazyDatasetArray.length) {
                ILazyDataset n2 = iLazyDatasetArray[list4];
                object[list4] = n2 instanceof AbstractDataset ? (AbstractDataset)n2 : DatasetUtils.convertToAbstractDataset((ILazyDataset)n2);
                ++list4;
            }
            aggregateDataset = DatasetUtils.concatenate((IDataset[])object, (int)0);
            aggregateDataset.setName(iLazyDataset.getName());
        } else {
            aggregateDataset = new AggregateDataset(bl, iLazyDatasetArray);
        }
        object = new ArrayList();
        if (bl) {
            for (List nArray : list3) {
                nArray.add(0, null);
            }
        }
        int[] nArray = aggregateDataset2.getShape();
        int n = nArray.length;
        ArrayList<ILazyDataset> arrayList = new ArrayList<ILazyDataset>();
        int n3 = bl ? 1 : 0;
        int n4 = 0;
        while (n4 < n) {
            int n5;
            Object object2;
            AxisSelection axisSelection = new AxisSelection(n, n4);
            object.add(axisSelection);
            if (n4 == 0) {
                object2 = new AxisChoice((ILazyDataset)aggregateDataset, 1);
                int[] n52 = new int[aggregateDataset.getRank()];
                n5 = 0;
                while (n5 < n52.length) {
                    n52[n5] = n5;
                    ++n5;
                }
                ((AxisChoice)object2).setIndexMapping(n52);
                ((AxisChoice)object2).setAxisNumber(0);
                axisSelection.addChoice((AxisChoice)object2, 1);
            }
            if ((object2 = list3.get(0).get(n4)) != null) {
                int n6 = 0;
                n5 = ((AxisSelection)object2).size();
                while (n6 < n5) {
                    Object object3;
                    Object object4;
                    arrayList.clear();
                    AxisChoice axisChoice = ((AxisSelection)object2).getAxis(n6);
                    int[] nArray2 = axisChoice.getIndexMapping();
                    for (List<AxisSelection> list4 : list3) {
                        object4 = list4.get(n4);
                        if (object4 == null) break;
                        object3 = ((AxisSelection)object4).getAxis(n6).getValues();
                        if (object3 == null) {
                            arrayList.clear();
                            logger.warn("Missing data for choice {} in dim:{} ", (Object)((AxisSelection)object2).getName(n6), (Object)n4);
                            break;
                        }
                        if (bl && n > 2 && object3.getRank() == 1) {
                            int[] nArray3 = Arrays.copyOfRange(nArray, n3, n);
                            nArray3[n4 - n3] = 1;
                            AbstractDataset abstractDataset = DatasetUtils.convertToAbstractDataset((ILazyDataset)object3);
                            int[] nArray4 = new int[nArray3.length];
                            Arrays.fill(nArray4, 1);
                            nArray4[n4 - n3] = object3.getSize();
                            abstractDataset.setShape(nArray4);
                            String string = object3.getName();
                            object3 = DatasetUtils.tile((IDataset)abstractDataset, (int[])nArray3);
                            object3.setName(string);
                            nArray2 = new int[nArray3.length];
                            int n7 = 0;
                            while (n7 < nArray2.length) {
                                nArray2[n7] = n7;
                                ++n7;
                            }
                        }
                        arrayList.add((ILazyDataset)object3);
                    }
                    if (arrayList.size() != 0) {
                        AggregateDataset aggregateDataset3 = new AggregateDataset(bl, arrayList.toArray(new ILazyDataset[0]));
                        AxisChoice axisChoice2 = new AxisChoice((ILazyDataset)aggregateDataset3, axisChoice.getPrimary());
                        object4 = ((AxisSelection)object2).getName(n6);
                        if (bl) {
                            if (aggregateDataset3.getRank() > 1) {
                                object3 = new int[n];
                                int n8 = 0;
                                while (n8 < nArray2.length) {
                                    object3[n8 + 1] = (ILazyDataset)(nArray2[n8] + 1);
                                    ++n8;
                                }
                                axisChoice2.setIndexMapping((int[])object3);
                            }
                            if (((String)object4).startsWith("dim:")) {
                                int n9 = Integer.parseInt(((String)object4).substring("dim:".length()));
                                object4 = "dim:" + (n9 + 1);
                                aggregateDataset3.setName((String)object4);
                            }
                        } else {
                            axisChoice2.setIndexMapping((int[])nArray2.clone());
                        }
                        axisChoice2.setAxisNumber(n4);
                        axisSelection.addChoice((String)object4, axisChoice2, ((AxisSelection)object2).getOrder(n6));
                    }
                    ++n6;
                }
            }
            ++n4;
        }
        return new DatasetSelection(inspectorType, (List<AxisSelection>)object, new ILazyDataset[]{aggregateDataset2});
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        if (!this.listeners.contains(iSelectionChangedListener)) {
            this.listeners.add(iSelectionChangedListener);
        }
    }

    public ISelection getSelection() {
        return this.multipleSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.listeners.remove(iSelectionChangedListener);
    }

    public void setSelection(ISelection iSelection) {
        if (iSelection instanceof DatasetSelection) {
            this.multipleSelection = (DatasetSelection)iSelection;
        }
        SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.multipleSelection);
        for (ISelectionChangedListener iSelectionChangedListener : this.listeners) {
            iSelectionChangedListener.selectionChanged(selectionChangedEvent);
        }
    }

    private final class CFDropAdapter
    extends ViewerDropAdapter {
        protected CFDropAdapter(Viewer viewer) {
            super(viewer);
        }

        public boolean performDrop(Object object) {
            int n;
            SelectedFile selectedFile = (SelectedFile)this.getCurrentTarget();
            int n2 = n = selectedFile == null ? 0 : CompareFilesEditor.this.fileList.indexOf(selectedFile);
            if (n < 0) {
                n = CompareFilesEditor.this.fileList.size();
            }
            String[] stringArray = (String[])object;
            boolean bl = true;
            String[] stringArray2 = stringArray;
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String string = stringArray2[n4];
                bl |= CompareFilesEditor.this.addFile(string, n++);
                ++n4;
            }
            return bl;
        }

        public boolean validateDrop(Object object, int n, TransferData transferData) {
            return FileTransfer.getInstance().isSupportedType(transferData);
        }
    }

    private final class CFEditingSupport
    extends EditingSupport {
        private CheckboxCellEditor editor;
        private Column column;

        public CFEditingSupport(TableViewer tableViewer, Column column, ICellEditorListener iCellEditorListener) {
            super((ColumnViewer)tableViewer);
            this.editor = null;
            if (column == Column.TICK) {
                this.editor = new CheckboxCellEditor((Composite)tableViewer.getTable(), 32);
                if (iCellEditorListener != null) {
                    this.editor.addListener(iCellEditorListener);
                }
            }
            this.column = column;
        }

        protected boolean canEdit(Object object) {
            return this.column == Column.TICK;
        }

        protected CellEditor getCellEditor(Object object) {
            return this.editor;
        }

        protected Object getValue(Object object) {
            SelectedFile selectedFile = (SelectedFile)object;
            if (this.column == Column.TICK) {
                return selectedFile.doUse();
            }
            return null;
        }

        protected void setValue(Object object, Object object2) {
            SelectedFile selectedFile = (SelectedFile)object;
            if (this.column == Column.TICK) {
                selectedFile.setUse((Boolean)object2);
            }
            this.getViewer().update(object, null);
            CompareFilesEditor.this.changeSelection();
        }
    }

    private static enum Column {
        TICK,
        PATH,
        VALUE;

    }

    private static class PathLabelProvider
    extends CellLabelProvider {
        private Display display;

        public PathLabelProvider(Display display) {
            this.display = display;
        }

        public void update(ViewerCell viewerCell) {
            SelectedFile selectedFile = (SelectedFile)viewerCell.getElement();
            viewerCell.setText(selectedFile.getAbsolutePath());
            viewerCell.setForeground(selectedFile.doUse() ? null : this.display.getSystemColor(15));
        }
    }

    private class TickLabelProvider
    extends CellLabelProvider {
        private final Image TICK = AnalysisRCPActivator.getImageDescriptor("icons/tick.png").createImage();
        private Display display;

        public TickLabelProvider(Display display) {
            this.display = display;
        }

        public void update(ViewerCell viewerCell) {
            SelectedFile selectedFile = (SelectedFile)viewerCell.getElement();
            if (selectedFile.doUse()) {
                viewerCell.setImage(this.TICK);
            } else {
                viewerCell.setImage(null);
            }
            Color color = null;
            if (!(CompareFilesEditor.this.currentDatasetSelection == null || selectedFile.hasData() && selectedFile.isDataOK())) {
                color = this.display.getSystemColor(7);
            }
            viewerCell.setBackground(color);
        }
    }

    private class ValueLabelProvider
    extends CellLabelProvider {
        private Display display;

        public ValueLabelProvider(Display display) {
            this.display = display;
        }

        public void update(ViewerCell viewerCell) {
            SelectedFile selectedFile = (SelectedFile)viewerCell.getElement();
            Color color = null;
            if (CompareFilesEditor.this.useRowIndexAsValue) {
                viewerCell.setText(selectedFile.getIndex());
            } else {
                viewerCell.setText(selectedFile.toString());
                if (!selectedFile.hasMetaValue()) {
                    color = this.display.getSystemColor(7);
                }
            }
            viewerCell.setBackground(color);
            viewerCell.setForeground(selectedFile.doUse() ? null : this.display.getSystemColor(15));
        }
    }
}

