/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.actions;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.SDAPlotter;
import uk.ac.gda.util.io.SortingUtils;

public class SelectedImageGridViewAction
extends AbstractHandler
implements IObjectActionDelegate {
    private static Logger logger = LoggerFactory.getLogger(SelectedImageGridViewAction.class);

    public void run(IAction iAction) {
        this.doAction();
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        return this.doAction();
    }

    public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
    }

    private Object doAction() {
        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        final IStructuredSelection iStructuredSelection = (IStructuredSelection)iWorkbenchPage.getSelection();
        Job job = new Job("Updating image Explorer View"){

            /*
             * WARNING - void declaration
             */
            protected IStatus run(IProgressMonitor iProgressMonitor) {
                if (iStructuredSelection != null) {
                    Object object;
                    Object[] objectArray = iStructuredSelection.toArray();
                    if (objectArray == null) {
                        return Status.CANCEL_STATUS;
                    }
                    ArrayList<String> arrayList = new ArrayList<String>();
                    try {
                        if (objectArray.length == 1) {
                            void var4_7;
                            Object object2;
                            Object object22 = null;
                            if (objectArray[0] instanceof IFolder) {
                                File exception = new File(((IFolder)objectArray[0]).getLocation().toOSString());
                            } else if (objectArray[0] instanceof File && ((File)(object2 = (File)objectArray[0])).isDirectory()) {
                                Object exception = object2;
                            }
                            if (var4_7 != null && (object2 = SortingUtils.getSortedFileList((File)var4_7)) != null && object2.size() > 0) {
                                object = object2.iterator();
                                while (object.hasNext()) {
                                    File file = (File)object.next();
                                    if (file.isDirectory()) continue;
                                    arrayList.add(file.getAbsolutePath());
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                        logger.error("Cannot open selected objects as folder!", (Throwable)exception);
                        return Status.CANCEL_STATUS;
                    }
                    if (arrayList.isEmpty()) {
                        object = objectArray;
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String string;
                            Object object3;
                            Object object4 = object[n2];
                            if (object4 instanceof IFile) {
                                object3 = (IFile)object4;
                                string = object3.getLocation().toString();
                                arrayList.add(string);
                            } else if (object4 instanceof File) {
                                object3 = (File)object4;
                                string = ((File)object3).getAbsolutePath();
                                arrayList.add(string);
                            }
                            ++n2;
                        }
                    }
                    try {
                        SDAPlotter.setupNewImageGrid((String)"ImageExplorer View", (int)arrayList.size());
                    }
                    catch (Exception exception) {
                        logger.debug("Problem with SDAPlotter.setupNewImageGrid", (Throwable)exception);
                        return Status.CANCEL_STATUS;
                    }
                    for (String string : arrayList) {
                        try {
                            SDAPlotter.plotImageToGrid((String)"ImageExplorer View", (String)string);
                        }
                        catch (Exception exception) {
                            logger.debug("Problem with SDAPlotter.plotImageToGrid()", (Throwable)exception);
                            return Status.CANCEL_STATUS;
                        }
                    }
                } else {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        return Boolean.TRUE;
    }
}

