/*
 * Decompiled with CFR 0.152.
 */
package com.swtdesigner;

import com.swtdesigner.SWTResourceManager;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class ResourceManager
extends SWTResourceManager {
    private static HashMap<ImageDescriptor, Image> m_DescriptorImageMap = new HashMap();
    private static HashMap<Image, HashMap<Image, Image>> m_ImageToDecoratorMap = new HashMap();
    private static HashMap<URL, Image> m_URLImageMap = new HashMap();

    public static void dispose() {
        ResourceManager.disposeColors();
        ResourceManager.disposeFonts();
        ResourceManager.disposeImages();
        ResourceManager.disposeCursors();
    }

    public static ImageDescriptor getImageDescriptor(Class<?> clazz, String string) {
        return ImageDescriptor.createFromFile(clazz, (String)string);
    }

    public static ImageDescriptor getImageDescriptor(String string) {
        try {
            return ImageDescriptor.createFromURL((URL)new File(string).toURI().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static Image getImage(ImageDescriptor imageDescriptor) {
        if (imageDescriptor == null) {
            return null;
        }
        Image image = m_DescriptorImageMap.get(imageDescriptor);
        if (image == null) {
            image = imageDescriptor.createImage();
            m_DescriptorImageMap.put(imageDescriptor, image);
        }
        return image;
    }

    public static Image decorateImage(final Image image, final Image image2, final int n) {
        Image image3;
        HashMap<Object, Object> hashMap = m_ImageToDecoratorMap.get(image);
        if (hashMap == null) {
            hashMap = new HashMap();
            m_ImageToDecoratorMap.put(image, hashMap);
        }
        if ((image3 = hashMap.get(image2)) == null) {
            final Rectangle rectangle = image.getBounds();
            final Rectangle rectangle2 = image2.getBounds();
            final Point point = new Point(rectangle.width, rectangle.height);
            CompositeImageDescriptor compositeImageDescriptor = new CompositeImageDescriptor(){

                protected void drawCompositeImage(int n3, int n2) {
                    this.drawImage(image.getImageData(), 0, 0);
                    if (n == 1) {
                        this.drawImage(image2.getImageData(), 0, 0);
                    } else if (n == 2) {
                        this.drawImage(image2.getImageData(), rectangle.width - rectangle2.width - 1, 0);
                    } else if (n == 3) {
                        this.drawImage(image2.getImageData(), 0, rectangle.height - rectangle2.height - 1);
                    } else if (n == 4) {
                        this.drawImage(image2.getImageData(), rectangle.width - rectangle2.width - 1, rectangle.height - rectangle2.height - 1);
                    }
                }

                protected Point getSize() {
                    return point;
                }
            };
            image3 = compositeImageDescriptor.createImage();
            hashMap.put(image2, image3);
        }
        return image3;
    }

    public static void disposeImages() {
        SWTResourceManager.disposeImages();
        Iterator<Object> iterator = m_DescriptorImageMap.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().dispose();
        }
        m_DescriptorImageMap.clear();
        iterator = m_URLImageMap.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().dispose();
        }
        m_URLImageMap.clear();
        for (HashMap hashMap : m_ImageToDecoratorMap.values()) {
            for (Image image : hashMap.values()) {
                image.dispose();
            }
        }
    }

    /*
     * Loose catch block
     */
    public static Image getPluginImage(Object object, String string) {
        try {
            Image image;
            URL uRL;
            block8: {
                uRL = ResourceManager.getPluginImageURL(object, string);
                if (!m_URLImageMap.containsKey(uRL)) break block8;
                return m_URLImageMap.get(uRL);
            }
            InputStream inputStream = uRL.openStream();
            try {
                image = ResourceManager.getImage(inputStream);
                m_URLImageMap.put(uRL, image);
            }
            finally {
                inputStream.close();
            }
            return image;
        }
        catch (Throwable throwable) {
            {
                catch (Throwable throwable2) {}
            }
        }
        return null;
    }

    public static ImageDescriptor getPluginImageDescriptor(Object object, String string) {
        try {
            URL uRL = ResourceManager.getPluginImageURL(object, string);
            return ImageDescriptor.createFromURL((URL)uRL);
        }
        catch (Throwable throwable) {
            try {
            }
            catch (Throwable throwable2) {}
            return null;
        }
    }

    private static URL getPluginImageURL(Object object, String string) throws Exception {
        Class<?> clazz;
        Class<?> clazz2;
        try {
            clazz2 = Class.forName("org.osgi.framework.Bundle");
            clazz = Class.forName("org.osgi.framework.BundleContext");
            if (clazz.isAssignableFrom(object.getClass())) {
                Method method = clazz.getMethod("getBundle", new Class[0]);
                Object object2 = method.invoke(object, new Object[0]);
                Class<?> clazz3 = Class.forName("org.eclipse.core.runtime.IPath");
                Class<?> clazz4 = Class.forName("org.eclipse.core.runtime.Path");
                Constructor<?> constructor = clazz4.getConstructor(String.class);
                Object obj = constructor.newInstance(string);
                Class<?> clazz5 = Class.forName("org.eclipse.core.runtime.Platform");
                Method method2 = clazz5.getMethod("find", clazz2, clazz3);
                return (URL)method2.invoke(null, object2, obj);
            }
        }
        catch (Throwable throwable) {}
        clazz2 = Class.forName("org.eclipse.core.runtime.Plugin");
        if (clazz2.isAssignableFrom(object.getClass())) {
            clazz = Class.forName("org.eclipse.core.runtime.IPath");
            Class<?> clazz6 = Class.forName("org.eclipse.core.runtime.Path");
            Constructor<?> constructor = clazz6.getConstructor(String.class);
            Object obj = constructor.newInstance(string);
            Method method = clazz2.getMethod("find", clazz);
            return (URL)method.invoke(object, obj);
        }
        return null;
    }
}

