/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jlibdc1394.impl.cmu;

import java.io.Serializable;
import java.util.Vector;
import net.sf.jlibdc1394.JDC1394VideoSetting;
import net.sf.jlibdc1394.JDC1394VideoSettings;
import net.sf.jlibdc1394.impl.cmu.JDC1394CamCMU;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDC1394VideoSettingsCMU
implements JDC1394VideoSettings,
Serializable {
    public static final int BRIGHTNESS = 0;
    public static final int AUTOEXPOSURE = 1;
    public static final int SHARPNESS = 2;
    public static final int WHITEBALANCE = 3;
    public static final int HUE = 4;
    public static final int SATURATION = 5;
    public static final int GAMMA = 6;
    public static final int SHUTTER = 7;
    public static final int GAIN = 8;
    public static final int IRIS = 9;
    public static final int FOCUS = 10;
    public static final int ZOOM = 11;
    public static final String[] settingsNames = new String[]{"Brightness", "Auto Exposure", "Sharpness", "White Balance", "Hue", "Saturation", "Gamma", "Shutter", "Gain", "Iris", "Focus", "Zoom"};
    private JDC1394VideoSetting controlBrightness;
    private JDC1394VideoSetting controlAutoExposure;
    private JDC1394VideoSetting controlSharpness;
    private JDC1394VideoSetting controlWhiteBalance;
    private JDC1394VideoSetting controlHue;
    private JDC1394VideoSetting controlSaturation;
    private JDC1394VideoSetting controlGamma;
    private JDC1394VideoSetting controlShutter;
    private JDC1394VideoSetting controlGain;
    private JDC1394VideoSetting controlIris;
    private JDC1394VideoSetting controlFocus;
    private JDC1394VideoSetting controlZoom;
    private JDC1394CamCMU theCamera;
    private int handle;

    private native int libGetIris(int var1);

    private native int libGetFocus(int var1);

    private native int libGetZoom(int var1);

    private native int libGetBrightness(int var1);

    private native int libGetAutoExposure(int var1);

    private native int libGetSharpness(int var1);

    private native int libGetWhiteBalanceU(int var1);

    private native int libGetWhiteBalanceV(int var1);

    private native int libGetHue(int var1);

    private native int libGetSaturation(int var1);

    private native int libGetGamma(int var1);

    private native int libGetShutter(int var1);

    private native int libGetGain(int var1);

    public native int libSetIris(int var1, int var2);

    public native int libSetFocus(int var1, int var2);

    public native int libSetZoom(int var1, int var2);

    public native int libSetBrightness(int var1, int var2);

    public native int libSetAutoExposure(int var1, int var2);

    public native int libSetSharpness(int var1, int var2);

    public native int libSetWhiteBalance(int var1, int var2, int var3);

    public native int libSetHue(int var1, int var2);

    public native int libSetSaturation(int var1, int var2);

    public native int libSetGamma(int var1, int var2);

    public native int libSetShutter(int var1, int var2);

    public native int libSetGain(int var1, int var2);

    private native void libGetIrisMinMax(int var1, int[] var2);

    private native void libGetFocusMinMax(int var1, int[] var2);

    private native void libGetZoomMinMax(int var1, int[] var2);

    private native void libGetBrightnessMinMax(int var1, int[] var2);

    private native void libGetAutoExposureMinMax(int var1, int[] var2);

    private native void libGetSharpnessMinMax(int var1, int[] var2);

    private native void libGetWhiteBalanceUMinMax(int var1, int[] var2);

    private native void libGetWhiteBalanceVMinMax(int var1, int[] var2);

    private native void libGetHueMinMax(int var1, int[] var2);

    private native void libGetSaturationMinMax(int var1, int[] var2);

    private native void libGetGammaMinMax(int var1, int[] var2);

    private native void libGetShutterMinMax(int var1, int[] var2);

    private native void libGetGainMinMax(int var1, int[] var2);

    public JDC1394VideoSettingsCMU(JDC1394CamCMU camera) {
        this.theCamera = camera;
        this.handle = this.theCamera.getHandle();
        this.initializeVideoSettings();
    }

    @Override
    public String[] getSettingsNames() {
        return settingsNames;
    }

    @Override
    public Vector<JDC1394VideoSetting> getAllSettings() {
        Vector<JDC1394VideoSetting> v = new Vector<JDC1394VideoSetting>(settingsNames.length);
        for (String s : settingsNames) {
            v.add(this.getSetting(s));
        }
        return v;
    }

    @Override
    public JDC1394VideoSetting getSetting(String name) {
        if (name == null) {
            return null;
        }
        if (name.equalsIgnoreCase(settingsNames[0])) {
            return this.controlBrightness;
        }
        if (name.equalsIgnoreCase(settingsNames[1])) {
            return this.controlAutoExposure;
        }
        if (name.equalsIgnoreCase(settingsNames[2])) {
            return this.controlSharpness;
        }
        if (name.equalsIgnoreCase(settingsNames[3])) {
            return this.controlWhiteBalance;
        }
        if (name.equalsIgnoreCase(settingsNames[4])) {
            return this.controlHue;
        }
        if (name.equalsIgnoreCase(settingsNames[5])) {
            return this.controlSaturation;
        }
        if (name.equalsIgnoreCase(settingsNames[6])) {
            return this.controlGamma;
        }
        if (name.equalsIgnoreCase(settingsNames[7])) {
            return this.controlShutter;
        }
        if (name.equalsIgnoreCase(settingsNames[8])) {
            return this.controlGain;
        }
        if (name.equalsIgnoreCase(settingsNames[9])) {
            return this.controlIris;
        }
        if (name.equalsIgnoreCase(settingsNames[10])) {
            return this.controlFocus;
        }
        if (name.equalsIgnoreCase(settingsNames[11])) {
            return this.controlZoom;
        }
        return null;
    }

    @Override
    public void setSetting(String name, JDC1394VideoSetting setting) {
        if (name == null || setting == null) {
            return;
        }
        if (name.equalsIgnoreCase(settingsNames[0])) {
            if (setting instanceof JDC1394VideoSetting) {
                this.setBrightness(setting);
            }
        } else if (name.equalsIgnoreCase(settingsNames[1])) {
            if (setting instanceof JDC1394VideoSetting) {
                this.setAutoExposure(setting);
            }
        } else if (name.equalsIgnoreCase(settingsNames[2])) {
            if (setting instanceof JDC1394VideoSetting) {
                this.setSharpness(setting);
            }
        } else if (name.equalsIgnoreCase(settingsNames[3])) {
            if (setting instanceof JDC1394VideoSetting) {
                this.setWhiteBalance(setting);
            }
        } else if (name.equalsIgnoreCase(settingsNames[4])) {
            if (setting instanceof JDC1394VideoSetting) {
                this.setHue(setting);
            }
        } else if (name.equalsIgnoreCase(settingsNames[5])) {
            if (setting instanceof JDC1394VideoSetting) {
                this.setSaturation(setting);
            }
        } else if (name.equalsIgnoreCase(settingsNames[6])) {
            if (setting instanceof JDC1394VideoSetting) {
                this.setGamma(setting);
            }
        } else if (name.equalsIgnoreCase(settingsNames[7])) {
            if (setting instanceof JDC1394VideoSetting) {
                this.setShutter(setting);
            }
        } else if (name.equalsIgnoreCase(settingsNames[8])) {
            if (setting instanceof JDC1394VideoSetting) {
                this.setGain(setting);
            }
        } else if (name.equalsIgnoreCase(settingsNames[9])) {
            if (setting instanceof JDC1394VideoSetting) {
                this.setIris(setting);
            }
        } else if (name.equalsIgnoreCase(settingsNames[10])) {
            if (setting instanceof JDC1394VideoSetting) {
                this.setFocus(setting);
            }
        } else if (name.equalsIgnoreCase(settingsNames[11]) && setting instanceof JDC1394VideoSetting) {
            this.setZoom(setting);
        }
    }

    @Override
    public JDC1394VideoSetting getAutoExposure() {
        return (JDC1394VideoSetting)this.controlAutoExposure.clone();
    }

    @Override
    public void setAutoExposure(JDC1394VideoSetting controlAutoExposure) {
        this.libSetAutoExposure(this.handle, controlAutoExposure.getValue1());
        this.controlAutoExposure = controlAutoExposure;
    }

    @Override
    public JDC1394VideoSetting getBrightness() {
        return (JDC1394VideoSetting)this.controlBrightness.clone();
    }

    @Override
    public void setBrightness(JDC1394VideoSetting controlBrightness) {
        this.libSetBrightness(this.handle, controlBrightness.getValue1());
        this.controlBrightness = controlBrightness;
    }

    @Override
    public JDC1394VideoSetting getFocus() {
        return (JDC1394VideoSetting)this.controlFocus.clone();
    }

    @Override
    public void setFocus(JDC1394VideoSetting controlFocus) {
        this.libSetFocus(this.handle, controlFocus.getValue1());
        this.controlFocus = controlFocus;
    }

    @Override
    public JDC1394VideoSetting getGain() {
        return (JDC1394VideoSetting)this.controlGain.clone();
    }

    @Override
    public void setGain(JDC1394VideoSetting controlGain) {
        this.libSetGain(this.handle, controlGain.getValue1());
        this.controlGain = controlGain;
    }

    @Override
    public JDC1394VideoSetting getGamma() {
        return (JDC1394VideoSetting)this.controlGamma.clone();
    }

    @Override
    public void setGamma(JDC1394VideoSetting controlGamma) {
        this.libSetGamma(this.handle, controlGamma.getValue1());
        this.controlGamma = controlGamma;
    }

    @Override
    public JDC1394VideoSetting getHue() {
        return (JDC1394VideoSetting)this.controlHue.clone();
    }

    @Override
    public void setHue(JDC1394VideoSetting controlHue) {
        this.libSetHue(this.handle, controlHue.getValue1());
        this.controlHue = controlHue;
    }

    @Override
    public JDC1394VideoSetting getIris() {
        return (JDC1394VideoSetting)this.controlIris.clone();
    }

    @Override
    public void setIris(JDC1394VideoSetting controlIris) {
        this.libSetIris(this.handle, controlIris.getValue1());
        this.controlIris = controlIris;
    }

    @Override
    public JDC1394VideoSetting getSaturation() {
        return (JDC1394VideoSetting)this.controlSaturation.clone();
    }

    @Override
    public void setSaturation(JDC1394VideoSetting controlSaturation) {
        this.libSetSaturation(this.handle, controlSaturation.getValue1());
        this.controlSaturation = controlSaturation;
    }

    @Override
    public JDC1394VideoSetting getSharpness() {
        return (JDC1394VideoSetting)this.controlSharpness.clone();
    }

    @Override
    public void setSharpness(JDC1394VideoSetting controlSharpness) {
        this.libSetSharpness(this.handle, controlSharpness.getValue1());
        this.controlSharpness = controlSharpness;
    }

    @Override
    public JDC1394VideoSetting getShutter() {
        return (JDC1394VideoSetting)this.controlShutter.clone();
    }

    @Override
    public void setShutter(JDC1394VideoSetting controlShutter) {
        this.libSetShutter(this.handle, controlShutter.getValue1());
        this.controlShutter = controlShutter;
    }

    @Override
    public JDC1394VideoSetting getZoom() {
        return (JDC1394VideoSetting)this.controlZoom.clone();
    }

    @Override
    public void setZoom(JDC1394VideoSetting controlZoom) {
        this.libSetZoom(this.handle, controlZoom.getValue1());
        this.controlZoom = controlZoom;
    }

    @Override
    public JDC1394VideoSetting getWhiteBalance() {
        return (JDC1394VideoSetting)this.controlWhiteBalance.clone();
    }

    @Override
    public void setWhiteBalance(JDC1394VideoSetting controlWhiteBalance) {
        this.libSetWhiteBalance(this.handle, controlWhiteBalance.getValue1(), controlWhiteBalance.getValue2());
        this.controlWhiteBalance = controlWhiteBalance;
    }

    protected void initializeVideoSettings() {
        int[] minMax = new int[]{2, 100};
        this.controlAutoExposure = new JDC1394VideoSetting(settingsNames[1]);
        this.libGetAutoExposureMinMax(this.handle, minMax);
        this.controlAutoExposure.setValue1(this.libGetAutoExposure(this.handle));
        this.controlAutoExposure.setMinValue(minMax[0]);
        this.controlAutoExposure.setMaxValue(minMax[1]);
        this.controlBrightness = new JDC1394VideoSetting(settingsNames[0]);
        this.libGetBrightnessMinMax(this.handle, minMax);
        this.controlBrightness.setValue1(this.libGetBrightness(this.handle));
        this.controlBrightness.setMinValue(minMax[0]);
        this.controlBrightness.setMaxValue(minMax[1]);
        this.controlGain = new JDC1394VideoSetting(settingsNames[8]);
        this.libGetGainMinMax(this.handle, minMax);
        this.controlGain.setValue1(this.libGetGain(this.handle));
        this.controlGain.setMinValue(minMax[0]);
        this.controlGain.setMaxValue(minMax[1]);
        this.controlGamma = new JDC1394VideoSetting(settingsNames[6]);
        this.libGetGammaMinMax(this.handle, minMax);
        this.controlGamma.setValue1(this.libGetGamma(this.handle));
        this.controlGamma.setMinValue(minMax[0]);
        this.controlGamma.setMaxValue(minMax[1]);
        this.controlFocus = new JDC1394VideoSetting(settingsNames[10]);
        this.libGetFocusMinMax(this.handle, minMax);
        this.controlFocus.setValue1(this.libGetFocus(this.handle));
        this.controlFocus.setMinValue(minMax[0]);
        this.controlFocus.setMaxValue(minMax[1]);
        this.controlHue = new JDC1394VideoSetting(settingsNames[4]);
        this.libGetHueMinMax(this.handle, minMax);
        this.controlHue.setValue1(this.libGetHue(this.handle));
        this.controlHue.setMinValue(minMax[0]);
        this.controlHue.setMaxValue(minMax[1]);
        this.controlIris = new JDC1394VideoSetting(settingsNames[9]);
        this.libGetIrisMinMax(this.handle, minMax);
        this.controlIris.setValue1(this.libGetIris(this.handle));
        this.controlIris.setMinValue(minMax[0]);
        this.controlIris.setMaxValue(minMax[1]);
        this.controlSaturation = new JDC1394VideoSetting(settingsNames[5]);
        this.libGetSaturationMinMax(this.handle, minMax);
        this.controlSaturation.setValue1(this.libGetSaturation(this.handle));
        this.controlSaturation.setMinValue(minMax[0]);
        this.controlSaturation.setMaxValue(minMax[1]);
        this.controlSharpness = new JDC1394VideoSetting(settingsNames[2]);
        this.libGetSharpnessMinMax(this.handle, minMax);
        this.controlSharpness.setValue1(this.libGetSharpness(this.handle));
        this.controlSharpness.setMinValue(minMax[0]);
        this.controlSharpness.setMaxValue(minMax[1]);
        this.controlShutter = new JDC1394VideoSetting(settingsNames[7]);
        this.libGetShutterMinMax(this.handle, minMax);
        this.controlShutter.setValue1(this.libGetShutter(this.handle));
        this.controlShutter.setMinValue(minMax[0]);
        this.controlShutter.setMaxValue(minMax[1]);
        this.controlWhiteBalance = new JDC1394VideoSetting(settingsNames[3]);
        this.libGetWhiteBalanceUMinMax(this.handle, minMax);
        this.controlWhiteBalance.setValue1(this.libGetWhiteBalanceU(this.handle));
        this.controlWhiteBalance.setValue2(this.libGetWhiteBalanceV(this.handle));
        this.controlWhiteBalance.setMinValue(minMax[0]);
        this.controlWhiteBalance.setMaxValue(minMax[1]);
        this.controlZoom = new JDC1394VideoSetting(settingsNames[11]);
        this.libGetZoomMinMax(this.handle, minMax);
        this.controlZoom.setValue1(this.libGetZoom(this.handle));
        this.controlZoom.setMinValue(minMax[0]);
        this.controlZoom.setMaxValue(minMax[1]);
    }
}

