/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jlibdc1394.impl.cmu;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sf.jlibdc1394.JDC1394CamException;
import net.sf.jlibdc1394.JDC1394VideoMode;
import net.sf.jlibdc1394.JDC1394VideoModes;
import net.sf.jlibdc1394.impl.JDC1394VideoModeNotifier;
import net.sf.jlibdc1394.impl.cmu.JDC1394CamCMU;

public class JDC1394VideoModesCMU
extends JDC1394VideoModeNotifier
implements JDC1394VideoModes {
    private List videoModes = new LinkedList();
    private List supportedVideoModes = null;
    private JDC1394VideoMode[] supportedVideoModesArray = null;
    private JDC1394CamCMU camera;
    private int handle;

    private native int libSetVideoFormat(int var1, int var2);

    private native int libSetVideoMode(int var1, int var2);

    private native int libSetVideoFrameRate(int var1, int var2);

    private native int libGetVideoFormat(int var1);

    private native int libGetVideoMode(int var1);

    private native int libGetVideoFrameRate(int var1);

    private native void libGetClip(int var1, int[] var2);

    private native int libSetClip(int var1, int var2, int var3, int var4, int var5);

    private native boolean libCheckColorCode(int var1, int var2);

    private native int libSetColorCode(int var1, int var2);

    private native int libGetColorCode(int var1);

    private native int libSetBytesPerPacket(int var1, int var2);

    private native int libGetBytesPerPacket(int var1);

    private native int libGetSizeMaxWidth(int var1);

    private native int libGetSizeMaxHeight(int var1);

    private native boolean libCheckCapability(int var1, int var2, int var3);

    public JDC1394VideoModesCMU(JDC1394CamCMU _camera) {
        if (_camera.getHandle() < 0) {
            throw new IllegalArgumentException("Camera handle must be >= 0!!");
        }
        this.handle = _camera.getHandle();
        this.camera = _camera;
    }

    protected void init() {
        this.createModeList();
    }

    public JDC1394VideoMode[] getSupportedVideoModes() {
        if (this.supportedVideoModes == null) {
            this.supportedVideoModes = new ArrayList(16);
            for (JDC1394VideoMode mode : this.videoModes) {
                if (!mode.isSupported()) continue;
                this.supportedVideoModes.add(mode);
            }
        }
        if (this.supportedVideoModesArray == null) {
            this.supportedVideoModesArray = new JDC1394VideoMode[this.supportedVideoModes.size()];
            int i = 0;
            Iterator iter = this.supportedVideoModes.iterator();
            while (iter.hasNext()) {
                JDC1394VideoMode mode;
                this.supportedVideoModesArray[i] = mode = (JDC1394VideoMode)iter.next();
                ++i;
            }
        }
        return this.supportedVideoModesArray;
    }

    public void setVideoMode(JDC1394VideoMode mode) throws JDC1394CamException {
        if (mode != null) {
            if (mode.getFormat() != 7) {
                this.setVideoFormat(mode.getFormat());
                this.setVideoMode(mode.getMode());
                this.setVideoFrameRate(mode.getSelectedFrameRate());
            } else {
                if (mode.getClip().width > this.getMaxWidthPartialScan()) {
                    throw new IllegalArgumentException("Specified width bigger than max value for this camera.");
                }
                if (mode.getClip().height > this.getMaxHeightPartialScan()) {
                    throw new IllegalArgumentException("Specified height bigger than max value for this camera.");
                }
                this.setVideoFormat(7);
                this.setVideoMode(0);
                this.setColorCode(mode.getColorCode());
                this.setClip(this.getClip());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVideoFormat(int vFormat) throws JDC1394CamException {
        JDC1394VideoModesCMU jDC1394VideoModesCMU = this;
        synchronized (jDC1394VideoModesCMU) {
            int ec = this.libSetVideoFormat(this.handle, vFormat);
            if (ec != JDC1394CamCMU.CAM_SUCCESS) {
                throw new JDC1394CamException(this.camera.getErrorDescription(ec));
            }
            this.notifyVideoFormatChanged(vFormat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVideoMode(int vMode) throws JDC1394CamException {
        JDC1394VideoModesCMU jDC1394VideoModesCMU = this;
        synchronized (jDC1394VideoModesCMU) {
            int ec = this.libSetVideoMode(this.handle, vMode);
            if (ec != JDC1394CamCMU.CAM_SUCCESS) {
                throw new JDC1394CamException(this.camera.getErrorDescription(ec));
            }
            this.notifyVideoModeChanged(vMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVideoFrameRate(int vFrameRate) throws JDC1394CamException {
        JDC1394VideoModesCMU jDC1394VideoModesCMU = this;
        synchronized (jDC1394VideoModesCMU) {
            int ec = this.libSetVideoFrameRate(this.handle, vFrameRate);
            if (ec != JDC1394CamCMU.CAM_SUCCESS) {
                throw new JDC1394CamException(this.camera.getErrorDescription(ec));
            }
            this.notifyFrameRateChanged(vFrameRate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVideoFormat() throws JDC1394CamException {
        JDC1394VideoModesCMU jDC1394VideoModesCMU = this;
        synchronized (jDC1394VideoModesCMU) {
            return this.libGetVideoFormat(this.handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVideoMode() throws JDC1394CamException {
        JDC1394VideoModesCMU jDC1394VideoModesCMU = this;
        synchronized (jDC1394VideoModesCMU) {
            return this.libGetVideoMode(this.handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVideoFrameRate() throws JDC1394CamException {
        JDC1394VideoModesCMU jDC1394VideoModesCMU = this;
        synchronized (jDC1394VideoModesCMU) {
            return this.libGetVideoMode(this.handle);
        }
    }

    public Rectangle getClip() throws JDC1394CamException {
        Rectangle result = new Rectangle();
        int[] rect = new int[4];
        this.libGetClip(this.handle, rect);
        result.setBounds(rect[0], rect[1], rect[2], rect[3]);
        return result;
    }

    public void setClip(Rectangle clip) throws JDC1394CamException {
        int result = this.libSetClip(this.handle, clip.x, clip.y, clip.width, clip.height);
        if (result != JDC1394CamCMU.CAM_SUCCESS) {
            throw new JDC1394CamException(this.camera.getErrorDescription(result));
        }
    }

    public boolean checkColorCode(int colorCode) throws JDC1394CamException {
        return this.libCheckColorCode(this.handle, colorCode);
    }

    public void setColorCode(int colorCode) throws JDC1394CamException {
        int ic = this.libSetColorCode(this.handle, colorCode);
        if (ic != JDC1394CamCMU.CAM_SUCCESS) {
            throw new JDC1394CamException(this.camera.getErrorDescription(ic));
        }
    }

    public int getColorCode() throws JDC1394CamException {
        return this.libGetColorCode(this.handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBytesPerPacket(int bytes) throws JDC1394CamException {
        JDC1394VideoModesCMU jDC1394VideoModesCMU = this;
        synchronized (jDC1394VideoModesCMU) {
            int ec = this.libSetBytesPerPacket(this.handle, bytes);
            if (ec != JDC1394CamCMU.CAM_SUCCESS) {
                throw new JDC1394CamException(this.camera.getErrorDescription(ec));
            }
        }
    }

    public int getBytesPerPacket() throws JDC1394CamException {
        return this.libGetBytesPerPacket(this.handle);
    }

    public int getMaxWidthPartialScan() throws JDC1394CamException {
        return this.libGetSizeMaxWidth(this.handle);
    }

    public int getMaxHeightPartialScan() throws JDC1394CamException {
        return this.libGetSizeMaxHeight(this.handle);
    }

    public boolean checkCapability(int format, int mode) throws JDC1394CamException {
        return this.libCheckCapability(this.handle, format, mode);
    }

    private native boolean libCheckCapability(int var1, int var2, int var3, int var4);

    public boolean checkCapability(int format, int mode, int frameRate) throws JDC1394CamException {
        return this.libCheckCapability(this.handle, format, mode, frameRate);
    }

    public Dimension getResolutionDimension() throws JDC1394CamException {
        int width = 0;
        int height = 0;
        int format = this.getVideoFormat();
        int mode = this.getVideoMode();
        if (format == 0) {
            if (mode == 0) {
                width = 160;
                height = 120;
            } else if (mode == 1) {
                width = 320;
                height = 240;
            } else {
                width = 640;
                height = 480;
            }
        } else if (format == 1) {
            if (mode == 0 || mode == 1 || mode == 2 || mode == 6) {
                width = 800;
                height = 600;
            } else {
                width = 1024;
                height = 768;
            }
        } else if (format == 7) {
            Rectangle clip = this.getClip();
            width = clip.width;
            height = clip.height;
        } else if (mode == 0 || mode == 1 || mode == 2 || mode == 6) {
            width = 1280;
            height = 960;
        } else {
            width = 1600;
            height = 1200;
        }
        return new Dimension(width, height);
    }

    private void addModeEntry(int format, int mode) {
        JDC1394VideoMode vMode = new JDC1394VideoMode(this.camera, format, mode);
        this.videoModes.add(vMode);
    }

    private void createModeList() {
        this.addModeEntry(0, 0);
        this.addModeEntry(0, 1);
        this.addModeEntry(0, 2);
        this.addModeEntry(0, 3);
        this.addModeEntry(0, 4);
        this.addModeEntry(0, 5);
        this.addModeEntry(0, 6);
        this.addModeEntry(1, 0);
        this.addModeEntry(1, 1);
        this.addModeEntry(1, 2);
        this.addModeEntry(1, 3);
        this.addModeEntry(1, 4);
        this.addModeEntry(1, 5);
        this.addModeEntry(1, 6);
        this.addModeEntry(1, 7);
        this.addModeEntry(2, 0);
        this.addModeEntry(2, 1);
        this.addModeEntry(2, 2);
        this.addModeEntry(2, 3);
        this.addModeEntry(2, 4);
        this.addModeEntry(2, 5);
        this.addModeEntry(2, 6);
        this.addModeEntry(2, 7);
        this.addModeEntry(7, 0);
        this.addModeEntry(7, 1);
        this.addModeEntry(7, 2);
        this.addModeEntry(7, 3);
        this.addModeEntry(7, 4);
        this.addModeEntry(7, 5);
        this.addModeEntry(7, 6);
        this.addModeEntry(7, 7);
    }

    static {
        try {
            System.loadLibrary("net_sf_jlibdc1394_impl_cmu_JDC1394CamCMU");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

