/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jlibdc1394.impl.cmu;

import java.awt.Rectangle;
import java.util.HashMap;
import net.sf.jlibdc1394.JDC1394Cam;
import net.sf.jlibdc1394.JDC1394CamException;
import net.sf.jlibdc1394.JDC1394CamPort;
import net.sf.jlibdc1394.JDC1394VideoModes;
import net.sf.jlibdc1394.JDC1394VideoSettings;
import net.sf.jlibdc1394.impl.JDC1394CamInitNotifier;
import net.sf.jlibdc1394.impl.cmu.JDC1394CamPortCMU;
import net.sf.jlibdc1394.impl.cmu.JDC1394VideoModesCMU;
import net.sf.jlibdc1394.impl.cmu.JDC1394VideoSettingsCMU;

public class JDC1394CamCMU
extends JDC1394CamInitNotifier
implements JDC1394Cam {
    public static int CAM_SUCCESS = 0;
    public static int CAM_ERROR = -1;
    public static int CAM_ERROR_NOT_INITIALIZED = 1;
    public static int CAM_ERROR_INVALID_VIDEO_SETTINGS = 2;
    public static int CAM_ERROR_BUSY = 3;
    public static int CAM_ERROR_INSUFFICIENT_RESOURCES = 4;
    public static int CAM_ERROR_PARAM_OUT_OF_RANGE = 5;
    public static int CAM_ERROR_FRAME_TIMEOUT = 6;
    public static HashMap ERROR_CODE_DESCRIPTIONS = new HashMap();
    public static final String LIBRARY_NAME = "net_sf_jlibdc1394_impl_cmu_JDC1394CamCMU";
    private int handle = this.libGetHandle();
    protected JDC1394CamPortCMU port;
    private boolean inited = false;
    private boolean imageAcquisitionStarted = false;
    private boolean imageCaptureStarted = false;
    private JDC1394VideoModesCMU modes = null;
    JDC1394VideoSettingsCMU videoSettings = null;

    private native int libGetHandle();

    private native int libSetCameraIndex(int var1, int var2);

    private native int libGetNode(int var1);

    private native int libInitCamera(int var1);

    private native int libSetVideoFormat(int var1, int var2);

    private native int libSetVideoMode(int var1, int var2);

    private native int libSetVideoFrameRate(int var1, int var2);

    private native int libGetVideoFormat(int var1);

    private native int libGetVideoMode(int var1);

    private native int libGetVideoFrameRate(int var1);

    private native int libStartImageAcquisition(int var1);

    private native int libStartImageCapture(int var1);

    private native int libStopImageAcquisition(int var1);

    private native int libStopImageCapture(int var1);

    private native int libAcquireImage(int var1, int[] var2);

    private native int libAcquireImageEx(int var1, boolean var2, int[] var3);

    private native int libCaptureImage(int var1, int[] var2);

    private native int libCaptureImageIntensity(int var1, int[] var2);

    private native int libCaptureImageIntensityDouble(int var1, double[] var2);

    private native String libGetCameraVendor(int var1);

    private native String libGetCameraModel(int var1);

    private native String libGetCameraUniqueID(int var1);

    private native String libGetCameraDescription(int var1);

    private native String libGetShortCameraDescription(int var1);

    private native String libGetFullCameraDescription(int var1);

    private native boolean libCheckCapability(int var1, int var2, int var3);

    private native boolean libCheckCapability(int var1, int var2, int var3, int var4);

    protected int getHandle() {
        return this.handle;
    }

    public JDC1394CamCMU() throws JDC1394CamException {
        if (this.handle < 0) {
            throw new JDC1394CamException("Library returned invalid handle: " + this.handle);
        }
    }

    void setJDC1394CamPort(JDC1394CamPortCMU port) {
        this.port = port;
    }

    public JDC1394CamPort getJDC1394CamPort() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initCamera() throws JDC1394CamException {
        if (this.inited) {
            return;
        }
        JDC1394CamCMU jDC1394CamCMU = this;
        synchronized (jDC1394CamCMU) {
            int ic = this.libInitCamera(this.handle);
            if (ic != CAM_SUCCESS) {
                throw new JDC1394CamException(this.getErrorDescription(ic));
            }
            this.notifyInitListeners();
        }
        this.inited = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCameraIndex(int camIndex) throws JDC1394CamException {
        JDC1394CamCMU jDC1394CamCMU = this;
        synchronized (jDC1394CamCMU) {
            int sc = this.libSetCameraIndex(this.handle, camIndex);
            if (sc != CAM_SUCCESS) {
                throw new JDC1394CamException(this.getErrorDescription(sc));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNode() throws JDC1394CamException {
        JDC1394CamCMU jDC1394CamCMU = this;
        synchronized (jDC1394CamCMU) {
            int node = this.libGetNode(this.handle);
            if (node == CAM_ERROR) {
                throw new JDC1394CamException(this.getErrorDescription(node));
            }
            return node;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startImageAcquisition() throws JDC1394CamException {
        JDC1394CamCMU jDC1394CamCMU = this;
        synchronized (jDC1394CamCMU) {
            if (this.imageAcquisitionStarted) {
                return;
            }
            int ec = this.libStartImageAcquisition(this.handle);
            if (ec != CAM_SUCCESS) {
                throw new JDC1394CamException(this.getErrorDescription(ec));
            }
            this.imageAcquisitionStarted = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startImageCapture() throws JDC1394CamException {
        JDC1394CamCMU jDC1394CamCMU = this;
        synchronized (jDC1394CamCMU) {
            if (this.imageCaptureStarted) {
                return;
            }
            int ec = this.libStartImageCapture(this.handle);
            if (ec != CAM_SUCCESS) {
                throw new JDC1394CamException(this.getErrorDescription(ec));
            }
            this.imageCaptureStarted = true;
        }
    }

    public boolean isImageAcquisitionStarted() {
        return this.imageAcquisitionStarted;
    }

    public boolean isImageCaptureStarted() {
        return this.imageCaptureStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopImageAcquisition() throws JDC1394CamException {
        JDC1394CamCMU jDC1394CamCMU = this;
        synchronized (jDC1394CamCMU) {
            if (!this.imageAcquisitionStarted) {
                return;
            }
            int ec = this.libStopImageAcquisition(this.handle);
            if (ec != CAM_SUCCESS) {
                throw new JDC1394CamException(this.getErrorDescription(ec));
            }
            this.imageAcquisitionStarted = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopImageCapture() throws JDC1394CamException {
        JDC1394CamCMU jDC1394CamCMU = this;
        synchronized (jDC1394CamCMU) {
            if (!this.imageCaptureStarted) {
                return;
            }
            int ec = this.libStopImageCapture(this.handle);
            if (ec != CAM_SUCCESS) {
                throw new JDC1394CamException(this.getErrorDescription(ec));
            }
            this.imageCaptureStarted = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireImage(int[] pixels) throws JDC1394CamException {
        JDC1394CamCMU jDC1394CamCMU = this;
        synchronized (jDC1394CamCMU) {
            int ec = this.libAcquireImage(this.handle, pixels);
            if (ec != CAM_SUCCESS) {
                throw new JDC1394CamException(this.getErrorDescription(ec));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireImageEx(boolean dropStaleFrames, int[] pixels) throws JDC1394CamException {
        JDC1394CamCMU jDC1394CamCMU = this;
        synchronized (jDC1394CamCMU) {
            int ec = this.libAcquireImageEx(this.handle, dropStaleFrames, pixels);
            if (ec != CAM_SUCCESS) {
                throw new JDC1394CamException(this.getErrorDescription(ec));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void captureImage(int[] pixels) throws JDC1394CamException {
        JDC1394CamCMU jDC1394CamCMU = this;
        synchronized (jDC1394CamCMU) {
            int ec = this.libCaptureImage(this.handle, pixels);
            if (ec != CAM_SUCCESS) {
                throw new JDC1394CamException(this.getErrorDescription(ec));
            }
        }
    }

    public JDC1394VideoModes getVideoModes() {
        if (this.modes == null) {
            this.modes = new JDC1394VideoModesCMU(this);
            this.modes.init();
        }
        return this.modes;
    }

    public static String getCMUErrorDescription(int errCode) {
        String result = (String)ERROR_CODE_DESCRIPTIONS.get(new Integer(errCode));
        if (result != null) {
            return result;
        }
        return "ERROR = " + errCode;
    }

    public String getErrorDescription(int errCode) {
        return JDC1394CamCMU.getCMUErrorDescription(errCode);
    }

    public int[] buildImageBuffer() throws JDC1394CamException {
        int[] result;
        int format = this.getVideoModes().getVideoFormat();
        int mode = this.getVideoModes().getVideoMode();
        System.out.println("Building image buffer format: " + format + ", mode: " + mode);
        if (format == 0) {
            result = mode == 0 ? new int[19200] : (mode == 1 ? new int[76800] : new int[307200]);
        } else if (format == 1) {
            result = mode == 0 || mode == 1 || mode == 2 || mode == 6 ? new int[480000] : new int[786432];
        } else if (format == 7) {
            Rectangle clip = this.getVideoModes().getClip();
            result = new int[clip.width * clip.height];
        } else {
            result = mode == 0 || mode == 1 || mode == 2 || mode == 6 ? new int[1228800] : new int[1920000];
        }
        return result;
    }

    public JDC1394VideoSettings getVideoSettings() {
        if (this.videoSettings == null) {
            this.videoSettings = new JDC1394VideoSettingsCMU(this);
        }
        return this.videoSettings;
    }

    public String getCameraDescription() {
        return this.libGetCameraDescription(this.handle);
    }

    public String getFullCameraDescription() {
        return this.libGetFullCameraDescription(this.handle);
    }

    public String getShortCameraDescription() {
        return this.libGetShortCameraDescription(this.handle);
    }

    public String getCameraVendor() {
        return this.libGetCameraVendor(this.handle);
    }

    public String getCameraModel() {
        return this.libGetCameraModel(this.handle);
    }

    public String getCameraUniqueID() {
        return this.libGetCameraUniqueID(this.handle);
    }

    static {
        try {
            System.loadLibrary(LIBRARY_NAME);
            System.out.println(JDC1394CamCMU.class.getName() + "<init>: loaded library " + LIBRARY_NAME);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        ERROR_CODE_DESCRIPTIONS.put(new Integer(CAM_ERROR), new String("CAM_ERROR: General Error from the I/O subsystem."));
        ERROR_CODE_DESCRIPTIONS.put(new Integer(CAM_ERROR_BUSY), new String("CAM_ERROR_BUSY: The camera is acquiring or capturing images and whatever you tried to do would break it."));
        ERROR_CODE_DESCRIPTIONS.put(new Integer(CAM_ERROR_INSUFFICIENT_RESOURCES), new String("CAM_ERROR_INSUFFICIENT_RESOURCES: The bus is saturated or a GlobalAlloc error occured.Try again by switching off/pausing some devices."));
        ERROR_CODE_DESCRIPTIONS.put(new Integer(CAM_ERROR_INVALID_VIDEO_SETTINGS), new String("CAM_ERROR_INVALID_VIDEO_SETTINGS: Somehow, you snuck invalid video settings into the system."));
        ERROR_CODE_DESCRIPTIONS.put(new Integer(CAM_ERROR_NOT_INITIALIZED), new String("CAM_ERROR_NOT_INITIALIZED: No camera selected and/or camera not initialized ."));
        ERROR_CODE_DESCRIPTIONS.put(new Integer(CAM_ERROR_FRAME_TIMEOUT), new String("CAM_ERROR_FRAME_TIMEOUT: The call to AcquireImage() timed out; the current image buffer contains invalid data."));
        ERROR_CODE_DESCRIPTIONS.put(new Integer(CAM_ERROR_PARAM_OUT_OF_RANGE), new String("CAM_ERROR_PARAM_OUT_OF_RANGE: Some parameter you passed is out of range (usually NULL)."));
    }
}

