/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jlibdc1394.impl;

import java.util.LinkedList;
import java.util.List;
import net.sf.jlibdc1394.event.JDC1394VideoModeListener;

public abstract class JDC1394VideoModeNotifier {
    private List videoModeListeners = new LinkedList();

    public void addVideoModeListener(JDC1394VideoModeListener videoModeListener) {
        this.videoModeListeners.add(videoModeListener);
    }

    public void removeVideoModeListener(JDC1394VideoModeListener videoModeListener) {
        this.videoModeListeners.remove(videoModeListener);
    }

    public void removeAllVideoModeListeners() {
        this.videoModeListeners.clear();
    }

    protected void notifyVideoModeChanged(int newMode) {
        for (JDC1394VideoModeListener listener : this.videoModeListeners) {
            try {
                listener.modeChanged(newMode);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    protected void notifyVideoFormatChanged(int newFormat) {
        for (JDC1394VideoModeListener listener : this.videoModeListeners) {
            try {
                listener.formatChanged(newFormat);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    protected void notifyFrameRateChanged(int newFrameRate) {
        for (JDC1394VideoModeListener listener : this.videoModeListeners) {
            try {
                listener.frameRateChanged(newFrameRate);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

