/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jlibdc1394.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import net.sf.jlibdc1394.JDC1394Cam;
import net.sf.jlibdc1394.JDC1394CamException;
import net.sf.jlibdc1394.JDC1394VideoMode;
import net.sf.jlibdc1394.gui.FrameRateTableModel;
import net.sf.jlibdc1394.gui.VideoModeTableModel;

public class DialogChooseMode
extends JDialog {
    private JLabel jLabelMode;
    private JLabel jLabelFrameRate;
    private JButton jButtonCancel;
    private JLabel jLabelDim;
    private JCheckBox jCheckAdjustPosToDim;
    private JTextField jTextDimW;
    private JTextField jTextDimH;
    private JLabel jLabelDimW;
    private JTextField jTextPosX;
    private JLabel jLabelPosY;
    private JLabel jLabelPosX;
    private JTextField jTextPosY;
    private JLabel jLabelPosition;
    private JLabel jLabelColorCode;
    private JComboBox jComboBoxColorCode;
    private JLabel jLabelDimH;
    private JPanel jPanelPartialInside;
    private JLabel jLabelPSCaption;
    private JPanel jPanelPartialScan;
    private JButton jButtonOK;
    private JTable jTableFrameRate;
    private JTable jTableMode;
    private JDC1394Cam theCamera;

    public DialogChooseMode(JDC1394Cam cam) {
        this(null, cam);
    }

    public DialogChooseMode(Frame owner, JDC1394Cam cam) {
        super(owner);
        this.theCamera = cam;
        try {
            this.jTableMode = new JTable();
            this.jTableFrameRate = new JTable();
            this.jButtonOK = new JButton();
            this.jButtonCancel = new JButton();
            this.jLabelMode = new JLabel();
            this.getContentPane().setLayout(null);
            this.setDefaultCloseOperation(2);
            this.setModal(true);
            this.setTitle("Camera Modes");
            this.setName("DialogChooseSettings");
            this.setSize(new Dimension(345, 260));
            this.jTableMode.setPreferredSize(new Dimension(160, 213));
            this.jTableMode.setBounds(14, 30, 160, 196);
            this.getContentPane().add(this.jTableMode);
            this.jTableMode.setBorder(new LineBorder(new Color(0, 0, 0), 1, false));
            this.jTableMode.addMouseListener(new MouseAdapter(){

                public void mouseReleased(MouseEvent evt) {
                    DialogChooseMode.this.jTableModeMouseReleased(evt);
                }
            });
            this.jTableFrameRate.setPreferredSize(new Dimension(139, 149));
            this.jTableFrameRate.setBounds(187, 30, 139, 95);
            this.getContentPane().add(this.jTableFrameRate);
            this.jTableFrameRate.setBorder(new LineBorder(new Color(0, 0, 0), 1, false));
            this.jButtonOK.setText("OK");
            this.jButtonOK.setPreferredSize(new Dimension(65, 20));
            this.jButtonOK.setBounds(183, 200, 65, 20);
            this.getContentPane().add(this.jButtonOK);
            this.jButtonOK.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    DialogChooseMode.this.jButtonOKActionPerformed(evt);
                }
            });
            this.jButtonCancel.setText("Cancel");
            this.jButtonCancel.setPreferredSize(new Dimension(77, 20));
            this.jButtonCancel.setBounds(255, 200, 77, 20);
            this.getContentPane().add(this.jButtonCancel);
            this.jButtonCancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    DialogChooseMode.this.jButtonCancelActionPerformed(evt);
                }
            });
            this.jLabelMode.setText("Mode");
            this.jLabelMode.setPreferredSize(new Dimension(60, 20));
            this.jLabelMode.setBounds(15, 9, 60, 20);
            this.getContentPane().add(this.jLabelMode);
            this.jLabelFrameRate = new JLabel();
            this.getContentPane().add(this.jLabelFrameRate);
            this.jLabelFrameRate.setText("Framerate");
            this.jLabelFrameRate.setPreferredSize(new Dimension(60, 20));
            this.jLabelFrameRate.setBounds(188, 9, 83, 20);
            this.jPanelPartialScan = new JPanel();
            this.getContentPane().add(this.jPanelPartialScan);
            this.jPanelPartialScan.setBounds(183, 12, 144, 175);
            this.jPanelPartialScan.setLayout(null);
            this.jPanelPartialScan.setVisible(true);
            this.jPanelPartialScan.setBorder(new LineBorder(new Color(0, 0, 0), 0, false));
            this.jLabelDimH = new JLabel();
            this.jPanelPartialScan.add(this.jLabelDimH);
            this.jLabelDimH.setText("H");
            this.jLabelDimH.setBounds(75, 130, 17, 17);
            this.jLabelPosition = new JLabel();
            this.jPanelPartialScan.add(this.jLabelPosition);
            this.jLabelPosition.setText("Position");
            this.jLabelPosition.setBounds(4, 65, 60, 11);
            this.jTextPosY = new JTextField();
            this.jPanelPartialScan.add(this.jTextPosY);
            this.jTextPosY.setBounds(90, 85, 43, 17);
            this.jLabelPosX = new JLabel();
            this.jPanelPartialScan.add(this.jLabelPosX);
            this.jLabelPosX.setText("X");
            this.jLabelPosX.setBounds(5, 85, 13, 17);
            this.jLabelPosY = new JLabel();
            this.jPanelPartialScan.add(this.jLabelPosY);
            this.jLabelPosY.setText("Y");
            this.jLabelPosY.setBounds(75, 85, 10, 17);
            this.jTextPosX = new JTextField();
            this.jPanelPartialScan.add(this.jTextPosX);
            this.jTextPosX.setBounds(22, 86, 43, 17);
            this.jLabelDimW = new JLabel();
            this.jPanelPartialScan.add(this.jLabelDimW);
            this.jLabelDimW.setText("W");
            this.jLabelDimW.setBounds(5, 130, 17, 17);
            this.jTextDimH = new JTextField();
            this.jPanelPartialScan.add(this.jTextDimH);
            this.jTextDimH.setBounds(90, 130, 43, 17);
            this.jTextDimH.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    DialogChooseMode.this.dimHChanged(evt);
                }
            });
            this.jTextDimW = new JTextField();
            this.jPanelPartialScan.add(this.jTextDimW);
            this.jTextDimW.setBounds(22, 130, 43, 17);
            this.jTextDimW.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    DialogChooseMode.this.dimWChanged(evt);
                }
            });
            this.jLabelPSCaption = new JLabel();
            this.jPanelPartialScan.add(this.jLabelPSCaption);
            this.jLabelPSCaption.setText("Partial Scan");
            this.jLabelPSCaption.setBounds(4, 0, 79, 16);
            this.jPanelPartialInside = new JPanel();
            this.jPanelPartialScan.add(this.jPanelPartialInside);
            this.jPanelPartialInside.setBounds(2, 18, 141, 155);
            this.jPanelPartialInside.setBorder(new LineBorder(new Color(0, 0, 0), 1, false));
            this.jPanelPartialInside.setLayout(null);
            this.jLabelDim = new JLabel();
            this.jPanelPartialInside.add(this.jLabelDim);
            this.jLabelDim.setText("Dimension");
            this.jLabelDim.setBounds(3, 92, 60, 16);
            this.jCheckAdjustPosToDim = new JCheckBox();
            this.jPanelPartialInside.add(this.jCheckAdjustPosToDim);
            this.jCheckAdjustPosToDim.setText("Adjust pos to X Y");
            this.jCheckAdjustPosToDim.setBounds(4, 133, 128, 19);
            ColorCodeComboBoxModel jComboBoxColorCodeModel = new ColorCodeComboBoxModel(this.theCamera);
            this.jComboBoxColorCode = new JComboBox();
            this.jPanelPartialInside.add(this.jComboBoxColorCode);
            this.jComboBoxColorCode.setModel(jComboBoxColorCodeModel);
            this.jComboBoxColorCode.setBounds(5, 19, 132, 21);
            this.jLabelColorCode = new JLabel();
            this.jPanelPartialInside.add(this.jLabelColorCode);
            this.jLabelColorCode.setText("Color code");
            this.jLabelColorCode.setBounds(2, 5, 121, 14);
            this.jPanelPartialScan.setVisible(true);
            this.jTableFrameRate.setVisible(false);
            this.jLabelFrameRate.setVisible(false);
            this.jTableMode.setModel(new VideoModeTableModel(cam));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void dimWChanged(PropertyChangeEvent evt) {
        if (this.jCheckAdjustPosToDim.isSelected()) {
            try {
                int width = Integer.parseInt(this.jTextDimW.getText());
                int posx = this.theCamera.getVideoModes().getMaxWidthPartialScan() - width;
                this.jTextPosX.setText("" + posx);
            }
            catch (Exception e) {
                return;
            }
        }
    }

    protected void dimHChanged(PropertyChangeEvent evt) {
        if (this.jCheckAdjustPosToDim.isSelected()) {
            try {
                int height = Integer.parseInt(this.jTextDimH.getText());
                int posy = this.theCamera.getVideoModes().getMaxHeightPartialScan() - height;
                this.jTextPosY.setText("" + posy);
            }
            catch (Exception e) {
                return;
            }
        }
    }

    public static void showDialog(JDC1394Cam cam, Component owner) {
        try {
            Dialog inst = null;
            if (owner != null) {
                inst = Frame.class.isAssignableFrom(owner.getClass()) ? new DialogChooseMode((Frame)owner, cam) : new DialogChooseMode(cam);
            }
            if (owner != null) {
                int newX = (int)((double)owner.getX() + Math.floor(owner.getWidth() / 2) - Math.floor(inst.getWidth() / 2));
                int newY = (int)((double)owner.getY() + Math.floor(owner.getHeight() / 2) - Math.floor(inst.getHeight() / 2));
                inst.setBounds(newX, newY, inst.getWidth(), inst.getHeight());
            }
            inst.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updatePartialScanValues() {
        try {
            Rectangle clip = this.theCamera.getVideoModes().getClip();
            this.jTextPosX.setText("" + clip.x);
            this.jTextPosY.setText("" + clip.y);
            this.jTextDimW.setText("" + clip.width);
            this.jTextDimH.setText("" + clip.height);
        }
        catch (JDC1394CamException e) {
            e.printStackTrace();
        }
    }

    protected void jTableModeMouseReleased(MouseEvent evt) {
        if (this.jTableMode.getSelectedRowCount() == 1) {
            if (this.theCamera.getVideoModes().getSupportedVideoModes()[this.jTableMode.getSelectedRow()].getFormat() == 7) {
                this.jTableFrameRate.setVisible(false);
                this.jLabelFrameRate.setVisible(false);
                this.updatePartialScanValues();
                this.jPanelPartialScan.setVisible(true);
            } else {
                this.jTableFrameRate.setVisible(true);
                this.jLabelFrameRate.setVisible(true);
                this.jPanelPartialScan.setVisible(false);
            }
            this.jTableFrameRate.setModel(new FrameRateTableModel(this.theCamera.getVideoModes().getSupportedVideoModes()[this.jTableMode.getSelectedRow()]));
        }
    }

    protected void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    protected void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTableMode.getSelectedRowCount() == 1) {
            JDC1394VideoMode mode = this.theCamera.getVideoModes().getSupportedVideoModes()[this.jTableMode.getSelectedRow()];
            if (mode.getFormat() != 7) {
                if (this.jTableFrameRate.getSelectedRowCount() == 1) {
                    mode.selectSupportedFrameRate(this.jTableFrameRate.getSelectedRow());
                }
            } else {
                int x = 0;
                int y = 0;
                int width = 0;
                int height = 0;
                try {
                    x = Integer.parseInt(this.jTextPosX.getText());
                    y = Integer.parseInt(this.jTextPosY.getText());
                    width = Integer.parseInt(this.jTextDimW.getText());
                    height = Integer.parseInt(this.jTextDimH.getText());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
                try {
                    mode.setColorCode(((ColorCodeComboBoxModel.SupportedCode)this.jComboBoxColorCode.getSelectedItem()).code);
                    mode.setClip(new Rectangle(x, y, width, height));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
            try {
                this.theCamera.getVideoModes().setVideoMode(mode);
            }
            catch (JDC1394CamException e1) {
                e1.printStackTrace();
            }
            this.dispose();
        }
    }

    protected class ColorCodeComboBoxModel
    extends DefaultComboBoxModel {
        private Vector supportedCodes = new Vector();
        private JDC1394Cam cam = null;

        public ColorCodeComboBoxModel(JDC1394Cam cam) {
            this.cam = cam;
            this.supportedCodes.clear();
            for (int i = 0; i < 7; ++i) {
                try {
                    if (!cam.getVideoModes().checkColorCode(i)) continue;
                    this.supportedCodes.add(new SupportedCode(i, "Colorcode " + i));
                    continue;
                }
                catch (JDC1394CamException e) {
                    e.printStackTrace();
                }
            }
        }

        public Object getElementAt(int arg0) {
            return this.supportedCodes.get(arg0);
        }

        public int getSize() {
            return this.supportedCodes.size();
        }

        protected class SupportedCode {
            public int code;
            public String desc;

            public SupportedCode(int code, String desc) {
                this.code = code;
                this.desc = desc;
            }

            public String toString() {
                return this.desc;
            }
        }
    }
}

