/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jlibdc1394.gui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import net.sf.jlibdc1394.JDC1394CamException;
import net.sf.jlibdc1394.JDC1394CamPort;

public class CameraListTableModel
extends AbstractTableModel {
    private JDC1394CamPort port;
    private List descriptions = new ArrayList();

    public CameraListTableModel(JDC1394CamPort port) {
        try {
            this.port = port;
            port.refreshCameraList();
            this.descriptions.addAll(port.getCameraDescriptions(1));
        }
        catch (JDC1394CamException e) {
            e.printStackTrace();
        }
    }

    public int getColumnCount() {
        return 1;
    }

    public int getRowCount() {
        try {
            return this.port.getNumberCameras();
        }
        catch (JDC1394CamException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean isCellEditable(int arg0, int arg1) {
        return false;
    }

    public Class getColumnClass(int arg0) {
        return String.class;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            if (rowIndex >= this.port.getNumberCameras()) {
                return null;
            }
            switch (columnIndex) {
                case 0: {
                    return (String)this.descriptions.get(rowIndex);
                }
            }
        }
        catch (JDC1394CamException e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }

    public void setValueAt(Object arg0, int arg1, int arg2) {
    }

    public String getColumnName(int arg0) {
        switch (arg0) {
            case 0: {
                return new String("Camera");
            }
        }
        return new String("");
    }
}

