/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jlibdc1394.examples;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import net.sf.jlibdc1394.JDC1394Cam;
import net.sf.jlibdc1394.JDC1394CamPort;
import net.sf.jlibdc1394.JDC1394Helper;
import net.sf.jlibdc1394.gui.DialogChooseCamera;
import net.sf.jlibdc1394.gui.DialogChooseMode;
import net.sf.jlibdc1394.gui.InternalFrameCamLiveView;
import net.sf.jlibdc1394.gui.InternalFrameCamSettings;
import net.sf.jlibdc1394.gui.JDC1394CamReceiver;

public class ExampleApp
extends JFrame
implements JDC1394CamReceiver {
    private JMenu jMenuCam;
    private JDesktopPane desktopPane;
    private JMenuItem exitMenuItem;
    private JSeparator jSeparator2;
    private JMenuItem jMenuItemLiveView;
    private JMenuItem jMenuItemSettings;
    private JMenuItem jMenuItemChooseMode;
    private JMenuItem jMenuItemChooseCam;
    private JMenu jMenuFile;
    private JMenuBar jMenuBar1;
    private JDC1394CamPort port;
    private JDC1394Cam cam;

    public static void main(String[] args) {
        try {
            ExampleApp inst = new ExampleApp();
            inst.setVisible(true);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public ExampleApp() {
        try {
            this.port = JDC1394Helper.getJDC1394CamPort();
        }
        catch (Throwable e) {
            this.cam = null;
        }
        if (this.cam != null) {
            try {
                this.port.checkLink();
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.cam = null;
            }
        }
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setSize(400, 300);
            this.desktopPane = new JDesktopPane();
            this.getContentPane().add((Component)this.desktopPane, "Center");
            this.jMenuBar1 = new JMenuBar();
            this.setJMenuBar(this.jMenuBar1);
            this.jMenuFile = new JMenu();
            this.jMenuBar1.add(this.jMenuFile);
            this.jMenuFile.setText("File");
            this.jSeparator2 = new JSeparator();
            this.jMenuFile.add(this.jSeparator2);
            this.exitMenuItem = new JMenuItem();
            this.jMenuFile.add(this.exitMenuItem);
            this.exitMenuItem.setText("Exit");
            this.exitMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    System.exit(0);
                }
            });
            this.jMenuCam = new JMenu();
            this.jMenuBar1.add(this.jMenuCam);
            this.jMenuCam.setText("Cam");
            this.jMenuItemChooseCam = new JMenuItem();
            this.jMenuCam.add(this.jMenuItemChooseCam);
            this.jMenuItemChooseCam.setText("Choose camera");
            this.jMenuItemChooseCam.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    System.out.println("About to show choose Camera Frame: port == null: " + (ExampleApp.this.port == null));
                    if (ExampleApp.this.port != null) {
                        DialogChooseCamera.showGUI(ExampleApp.this.port, ExampleApp.this, ExampleApp.this);
                    }
                }
            });
            this.jMenuItemChooseMode = new JMenuItem();
            this.jMenuCam.add(this.jMenuItemChooseMode);
            this.jMenuItemChooseMode.setText("Choose camera mode");
            this.jMenuItemChooseMode.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    if (ExampleApp.this.cam == null) {
                        return;
                    }
                    DialogChooseMode.showDialog(ExampleApp.this.cam, ExampleApp.this);
                }
            });
            this.jMenuItemSettings = new JMenuItem();
            this.jMenuCam.add(this.jMenuItemSettings);
            this.jMenuItemSettings.setText("Show camera settings");
            this.jMenuItemSettings.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    if (ExampleApp.this.cam == null) {
                        return;
                    }
                    try {
                        InternalFrameCamSettings frameCamControls = new InternalFrameCamSettings(ExampleApp.this.cam);
                        ExampleApp.this.desktopPane.add(frameCamControls);
                        frameCamControls.setVisible(true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            this.jMenuItemLiveView = new JMenuItem();
            this.jMenuCam.add(this.jMenuItemLiveView);
            this.jMenuItemLiveView.setText("Live View");
            this.jMenuItemLiveView.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        InternalFrameCamLiveView frameLiveView = new InternalFrameCamLiveView(ExampleApp.this.cam);
                        ExampleApp.this.desktopPane.add(frameLiveView);
                        frameLiveView.setVisible(true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void receiveCam(JDC1394Cam camera) {
        this.cam = camera;
    }
}

