/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jlibdc1394.config;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.sf.jlibdc1394.JDC1394CamException;
import net.sf.jlibdc1394.JDC1394CamPort;
import net.sf.jlibdc1394.JDC1394Helper;
import net.sf.jlibdc1394.config.JLibDC1394CamConfig;

public class JLibDC1394CamRegistry {
    public static final String CAMERA_CONFIG_FILENAME = "net.sf.jlibdc1394.camconfig.xml";
    private File confFile;
    private Map cameraConfigs;
    private int nextConfigID;
    private JDC1394CamPort camPort;
    private static JLibDC1394CamRegistry sharedInstance;

    public JLibDC1394CamRegistry() {
    }

    protected JLibDC1394CamRegistry(boolean createPort, URL portConfURL) {
        if (createPort) {
            this.createCamPort(portConfURL);
        }
    }

    private void createCamPort(URL portConfURL) {
        try {
            this.camPort = portConfURL == null ? JDC1394Helper.getJDC1394CamPort() : JDC1394Helper.getJDC1394CamPort(portConfURL);
        }
        catch (JDC1394CamException e) {
            throw new RuntimeException(e);
        }
    }

    public JDC1394CamPort getCamPort() {
        return this.camPort;
    }

    public Collection getCamConfigs() {
        return this.cameraConfigs.values();
    }

    public JLibDC1394CamConfig getCamConfig(int camConfigID) {
        return (JLibDC1394CamConfig)this.cameraConfigs.get(new Integer(camConfigID));
    }

    public JLibDC1394CamConfig newCamConfig() {
        JLibDC1394CamConfig result = new JLibDC1394CamConfig(++this.nextConfigID, this);
        this.setNextConfigID(this.nextConfigID);
        this.cameraConfigs.put(new Integer(result.getConfigID()), result);
        return result;
    }

    public int getProbableNextConfigID() {
        return this.nextConfigID;
    }

    public void setRegistryDir(String registryDir) {
        File newConfFile;
        File tmpDir = new File(registryDir);
        if (!tmpDir.exists()) {
            try {
                if (!tmpDir.createNewFile()) {
                    throw new RuntimeException("Given registryDir " + registryDir + " does not exists and could not be created.");
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.confFile = newConfFile = new File(tmpDir, CAMERA_CONFIG_FILENAME);
    }

    public Map getCameraConfigs() {
        return this.cameraConfigs;
    }

    public void setCameraConfigs(Map cameraConfigs) {
        this.cameraConfigs = cameraConfigs;
    }

    public int getNextConfigID() {
        return this.nextConfigID;
    }

    public void setNextConfigID(int nextConfigID) {
        this.nextConfigID = nextConfigID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store() {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                JLibDC1394CamRegistry.saveRegistry(this, this.getClass().getClassLoader());
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveRegistry(JLibDC1394CamRegistry registry, ClassLoader classLoader) throws IOException {
        File file = registry.confFile.getCanonicalFile();
        System.out.println("Saving CamRegistry to " + registry.confFile.getCanonicalFile());
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            if (!file.createNewFile()) {
                throw new RuntimeException("Registry confFile " + registry.confFile + " does not exist and can not be created.");
            }
        }
        FileOutputStream fout = new FileOutputStream(file);
        try {
            XMLEncoder e = new XMLEncoder(fout);
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(classLoader);
                try {
                    e.writeObject(registry);
                }
                finally {
                    if (e != null) {
                        e.close();
                    }
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
        finally {
            if (fout != null) {
                fout.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JLibDC1394CamRegistry loadRegistry(File confFile, URL portConfURL, ClassLoader classLoader) throws IOException {
        JLibDC1394CamRegistry registry = null;
        if (!confFile.exists()) {
            registry = new JLibDC1394CamRegistry(true, portConfURL);
            registry.cameraConfigs = new HashMap();
            registry.nextConfigID = 0;
            registry.confFile = confFile;
            return registry;
        }
        FileInputStream fin = new FileInputStream(confFile);
        try {
            XMLDecoder d = new XMLDecoder(fin);
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(classLoader);
                try {
                    registry = (JLibDC1394CamRegistry)d.readObject();
                }
                finally {
                    if (d != null) {
                        d.close();
                    }
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
        finally {
            if (fin != null) {
                fin.close();
            }
        }
        if (registry != null) {
            registry.confFile = confFile;
        }
        if (registry != null) {
            registry.createCamPort(portConfURL);
        }
        if (registry != null) {
            registry.validate();
        }
        return registry;
    }

    protected void validate() {
        for (JLibDC1394CamConfig config : this.cameraConfigs.values()) {
            config.setRegsitry(this);
        }
    }

    public static JLibDC1394CamRegistry getSharedInstance(String registryDir, URL portConfURL) {
        if (sharedInstance == null) {
            File tmpDir = new File(registryDir);
            if (!tmpDir.exists()) {
                try {
                    if (!tmpDir.createNewFile()) {
                        throw new RuntimeException("Given registryDir " + registryDir + " does not exists and could not be created.");
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            File confFile = new File(tmpDir, CAMERA_CONFIG_FILENAME);
            try {
                sharedInstance = JLibDC1394CamRegistry.loadRegistry(confFile, portConfURL, JLibDC1394CamRegistry.class.getClassLoader());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (sharedInstance == null) {
                throw new IllegalStateException("Could not create an instance of JLibDC1394CamRegistry");
            }
        }
        return sharedInstance;
    }

    public static JLibDC1394CamRegistry getSharedInstance() {
        if (sharedInstance == null) {
            return null;
        }
        return JLibDC1394CamRegistry.getSharedInstance(null, null);
    }
}

