/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jlibdc1394.config;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.sf.jlibdc1394.JDC1394Cam;
import net.sf.jlibdc1394.JDC1394CamException;
import net.sf.jlibdc1394.config.DetachedVideoModes;
import net.sf.jlibdc1394.config.DetachedVideoSettings;
import net.sf.jlibdc1394.config.JDC1394CamProxy;
import net.sf.jlibdc1394.config.JLibDC1394CamRegistry;
import net.sf.jlibdc1394.event.JDC1394VideoModeListener;

public class JLibDC1394CamConfig {
    private int configID;
    private String configName;
    private int camIndex;
    private DetachedVideoModes videoModes;
    private DetachedVideoSettings videoSettings;
    private JLibDC1394CamRegistry registry;
    private List camProxies = new ArrayList();
    private JDC1394Cam camera;
    private JDC1394VideoModeListener modeListener = new JDC1394VideoModeListener(){

        public void formatChanged(int newFormat) {
            this.applySettings();
        }

        public void modeChanged(int newMode) {
            this.applySettings();
        }

        public void frameRateChanged(int newFrameRate) {
            this.applySettings();
        }

        public void clipChanged(Rectangle newClip) {
            this.applySettings();
        }

        private void applySettings() {
            try {
                if (JLibDC1394CamConfig.this.getAllocatedProxy() != null) {
                    JLibDC1394CamConfig.this.applySettingsToCamera();
                }
            }
            catch (JDC1394CamException e) {
                throw new RuntimeException(e);
            }
        }
    };

    public JLibDC1394CamConfig() {
    }

    public JLibDC1394CamConfig(int configID, JLibDC1394CamRegistry registry) {
        this.setConfigID(configID);
        this.registry = registry;
    }

    protected JDC1394Cam getCamera() {
        if (this.camera == null) {
            try {
                this.camera = this.registry.getCamPort().selectCamera(this.camIndex);
                this.applySettingsToCamera();
            }
            catch (JDC1394CamException e) {
                throw new RuntimeException(e);
            }
        }
        return this.camera;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applySettingsToCamera() throws JDC1394CamException {
        JDC1394CamProxy oldProxy = this.getAllocatedProxy();
        try {
            this.allocateCameraProxy(null);
            this.getCamera();
            this.camera.stopImageAcquisition();
            this.camera.stopImageCapture();
            this.camera.getVideoModes().setVideoMode(this.getVideoModes().getMode());
            this.camera.getVideoModes().setVideoFormat(this.getVideoModes().getFormat());
            this.camera.getVideoModes().setVideoFrameRate(this.getVideoModes().getFrameRate());
            this.camera.initCamera();
        }
        finally {
            this.allocateCameraProxy(oldProxy);
        }
    }

    public JDC1394CamProxy createCameraProxy(boolean allocate) {
        JDC1394CamProxy proxy = new JDC1394CamProxy(this.configID, this.registry, this.getCamera());
        this.camProxies.add(proxy);
        if (allocate) {
            this.allocateCameraProxy(proxy);
        }
        return proxy;
    }

    public void allocateCameraProxy(JDC1394CamProxy proxy) {
        for (JDC1394CamProxy listProxy : this.camProxies) {
            listProxy.setAllocated(false);
        }
        if (proxy != null) {
            proxy.setAllocated(true);
        }
    }

    public JDC1394CamProxy getAllocatedProxy() {
        for (JDC1394CamProxy proxy : this.camProxies) {
            if (!proxy.isAllocated()) continue;
            return proxy;
        }
        return null;
    }

    public void deallocateCameraProxy(JDC1394CamProxy proxy) {
        if (proxy != null) {
            proxy.setAllocated(false);
        }
    }

    void setRegsitry(JLibDC1394CamRegistry registry) {
        this.registry = registry;
    }

    public int getConfigID() {
        return this.configID;
    }

    public void setConfigID(int configID) {
        this.configID = configID;
    }

    public String getConfigName() {
        return this.configName;
    }

    public void setConfigName(String configName) {
        this.configName = configName;
    }

    public int getCamIndex() {
        return this.camIndex;
    }

    public void setCamIndex(int camIndex) {
        this.camIndex = camIndex;
        if (this.registry != null) {
            // empty if block
        }
    }

    public DetachedVideoModes getVideoModes() {
        return this.videoModes;
    }

    public void setVideoModes(DetachedVideoModes videoModes) {
        this.videoModes = videoModes;
        if (this.videoModes != null) {
            this.videoModes.addVideoModeListener(this.modeListener);
        }
    }

    public DetachedVideoSettings getVideoSettings() {
        return this.videoSettings;
    }

    public void setVideoSettings(DetachedVideoSettings videoSettings) {
        this.videoSettings = videoSettings;
    }
}

