/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jlibdc1394;

import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import net.sf.jlibdc1394.JDC1394Cam;
import net.sf.jlibdc1394.JDC1394CamException;

public class JDC1394VideoMode
extends AbstractTableModel
implements Serializable {
    public static final int FORMAT_PARTIAL_SCAN = 7;
    private int format;
    private int mode;
    private Rectangle clip;
    private int colorCode;
    public List frameRates;
    public int selectedFrameRate;
    private boolean isSupported;
    private JDC1394Cam camera;

    public JDC1394VideoMode(JDC1394Cam cam, int format, int mode) {
        this.format = format;
        this.mode = mode;
        this.frameRates = new ArrayList();
        this.frameRates.add(new FrameRate(0));
        this.frameRates.add(new FrameRate(1));
        this.frameRates.add(new FrameRate(2));
        this.frameRates.add(new FrameRate(3));
        this.frameRates.add(new FrameRate(4));
        this.frameRates.add(new FrameRate(5));
        this.selectFrameRate(0);
        this.getDescription();
        this.isSupported = false;
        try {
            this.isSupported = cam.getVideoModes().checkCapability(format, mode);
            for (int i = 0; i < this.frameRates.size(); ++i) {
                ((FrameRate)this.frameRates.get(i)).isSupported = cam.getVideoModes().checkCapability(format, mode, i);
            }
        }
        catch (JDC1394CamException e) {
            e.printStackTrace();
        }
    }

    public void selectFrameRate(int selFrameRate) {
        this.selectedFrameRate = selFrameRate;
    }

    public void selectSupportedFrameRate(int rowIndex) {
        int count = -1;
        for (int i = 0; i < this.frameRates.size(); ++i) {
            if (((FrameRate)this.frameRates.get(i)).isSupported) {
                ++count;
            }
            if (count != rowIndex) continue;
            this.selectedFrameRate = i;
            return;
        }
    }

    public static String getFrameRateDescription(int frameRate) {
        switch (frameRate) {
            case 0: {
                return "1.875 fps";
            }
            case 1: {
                return "3.75 fps";
            }
            case 2: {
                return "7.5 fps";
            }
            case 3: {
                return "15 fps";
            }
            case 4: {
                return "30 fps";
            }
            case 5: {
                return "60 fps";
            }
        }
        return "";
    }

    public String getFrameRateDescription() {
        return JDC1394VideoMode.getFrameRateDescription(this.selectedFrameRate);
    }

    public String getDescription() {
        return JDC1394VideoMode.getDescription(this.format, this.mode);
    }

    public static String getDescription(int format, int mode) {
        String description = "";
        switch (format) {
            case 0: {
                switch (mode) {
                    case 0: {
                        description = "160x120 YUV(4:4:4) ";
                        break;
                    }
                    case 1: {
                        description = "320x240 YUV(4:2:2) ";
                        break;
                    }
                    case 2: {
                        description = "640x480  YUV(4:1:1) ";
                        break;
                    }
                    case 3: {
                        description = "640x480  YUV(4:2:2) ";
                        break;
                    }
                    case 4: {
                        description = "640x480  RGB ";
                        break;
                    }
                    case 5: {
                        description = "640x480  Mono (8-bit) ";
                        break;
                    }
                    case 6: {
                        description = "640x480  Mono (16-bit) ";
                    }
                }
                break;
            }
            case 1: {
                switch (mode) {
                    case 0: {
                        description = "800x600  YUV(4:2:2) ";
                        break;
                    }
                    case 1: {
                        description = "800x600  RGB ";
                        break;
                    }
                    case 2: {
                        description = "800x600  Mono (8-bit) ";
                        break;
                    }
                    case 3: {
                        description = "1024x768  YUV(4:2:2) ";
                        break;
                    }
                    case 4: {
                        description = "1024x768  RGB ";
                        break;
                    }
                    case 5: {
                        description = "1024x768  Mono (8-bit) ";
                        break;
                    }
                    case 6: {
                        description = "800x600  Mono (16-bit) ";
                        break;
                    }
                    case 7: {
                        description = "1024x768  Mono (16-bit) ";
                    }
                }
                break;
            }
            case 2: {
                switch (mode) {
                    case 0: {
                        description = "1280x960  YUV(4:2:2) ";
                        break;
                    }
                    case 1: {
                        description = "800x600  RGB ";
                        break;
                    }
                    case 2: {
                        description = "1280x960  RGB ";
                        break;
                    }
                    case 3: {
                        description = "1280x960  Mono (8-bit) ";
                        break;
                    }
                    case 4: {
                        description = "1600x1200  YUV(4:2:2) ";
                        break;
                    }
                    case 5: {
                        description = "1600x1200  Mono (8-bit) ";
                        break;
                    }
                    case 6: {
                        description = "1280x960  Mono (16-bit) ";
                        break;
                    }
                    case 7: {
                        description = "1600x1200  Mono (16-bit) ";
                    }
                }
                break;
            }
            case 7: {
                description = "Partial Scan ";
            }
        }
        return description;
    }

    public int hashCode() {
        return ("" + this.format + "" + this.mode).hashCode();
    }

    public String toString() {
        return "(<" + this.format + "," + this.mode + "> " + this.getDescription() + " " + this.getFrameRateDescription() + ")";
    }

    public int getColumnCount() {
        return 1;
    }

    public int getRowCount() {
        int count = 0;
        for (int i = 0; i < this.frameRates.size(); ++i) {
            if (!((FrameRate)this.frameRates.get(i)).isSupported) continue;
            ++count;
        }
        return count;
    }

    public Class getColumnClass(int arg0) {
        return FrameRate.class;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        int count = -1;
        for (int i = 0; i < this.frameRates.size(); ++i) {
            if (((FrameRate)this.frameRates.get(i)).isSupported) {
                ++count;
            }
            if (count != rowIndex) continue;
            return JDC1394VideoMode.getFrameRateDescription(i);
        }
        return null;
    }

    public int getFormat() {
        return this.format;
    }

    public void setFormat(int format) {
        this.format = format;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getSelectedFrameRate() {
        return this.selectedFrameRate;
    }

    public void setSelectedFrameRate(int selectedFrameRate) {
        this.selectedFrameRate = selectedFrameRate;
    }

    public List getFrameRates() {
        return this.frameRates;
    }

    public Rectangle getClip() {
        return this.clip;
    }

    public void setClip(Rectangle clip) {
        this.clip = clip;
    }

    public int getColorCode() {
        return this.colorCode;
    }

    public void setColorCode(int colorCode) {
        this.colorCode = colorCode;
    }

    public boolean isSupported() {
        return this.isSupported;
    }

    public static class FrameRate {
        private int frameRate;
        private boolean isSupported;

        public FrameRate(int frameRate) {
            this.frameRate = frameRate;
            this.isSupported = false;
        }

        public String toString() {
            return JDC1394VideoMode.getFrameRateDescription(this.frameRate);
        }

        public int getFrameRate() {
            return this.frameRate;
        }

        public void setFrameRate(int frameRate) {
            this.frameRate = frameRate;
        }

        public boolean isSupported() {
            return this.isSupported;
        }

        public void setSupported(boolean isSupported) {
            this.isSupported = isSupported;
        }
    }
}

