/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.beans;

import de.jtem.beans.ChangeEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SimpleColorChooser
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = -6452509893745135407L;
    private JSlider redSlider;
    private JSlider greenSlider;
    private JSlider blueSlider;
    private JSlider alphaSlider;
    private Color color;
    private ChangeListener changeListener;
    private boolean updating = false;
    private boolean withAlpha;
    private JButton closeButton;

    public SimpleColorChooser() {
        this(Color.white, false);
    }

    public SimpleColorChooser(Color color, boolean withAlpha) {
        super(new BorderLayout());
        this.color = color;
        this.withAlpha = withAlpha;
        Box sliderBox = new Box(1);
        this.redSlider = this.makeSlider(color.getRed(), "red");
        sliderBox.add(this.makeSliderBox(this.redSlider, color.getRed(), "red"));
        this.greenSlider = this.makeSlider(color.getGreen(), "green");
        sliderBox.add(this.makeSliderBox(this.greenSlider, color.getGreen(), "green"));
        this.blueSlider = this.makeSlider(color.getBlue(), "blue");
        sliderBox.add(this.makeSliderBox(this.blueSlider, color.getBlue(), "blue"));
        if (withAlpha) {
            this.alphaSlider = this.makeSlider(color.getAlpha(), "alpha");
            sliderBox.add(this.makeSliderBox(this.alphaSlider, color.getAlpha(), "alpha"));
        }
        this.add((Component)sliderBox, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.setBorder(new EmptyBorder(10, 0, 0, 0));
        this.closeButton = new JButton("Close");
        buttonPanel.add(this.closeButton);
        this.add("South", buttonPanel);
    }

    public void addActionListener(ActionListener l) {
        this.closeButton.addActionListener(l);
    }

    public void removeActionListener(ActionListener l) {
        this.closeButton.removeActionListener(l);
    }

    private JSlider makeSlider(int value, String text) {
        JSlider slider = new JSlider(0, 0, 255, value);
        slider.setMajorTickSpacing(64);
        slider.setMinorTickSpacing(8);
        slider.setPaintTicks(true);
        slider.setPaintLabels(false);
        slider.addChangeListener(this);
        return slider;
    }

    private JComponent makeSliderBox(final JSlider slider, int value, String text) {
        Box sliderBox = new Box(0);
        sliderBox.add(slider);
        final JLabel label = new JLabel(String.valueOf(value));
        label.setForeground(Color.red);
        label.setPreferredSize(new Dimension(40, 20));
        label.setMinimumSize(new Dimension(40, 20));
        label.setBorder(new EmptyBorder(0, 10, 0, 0));
        slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                label.setText(String.valueOf(slider.getValue()));
            }
        });
        sliderBox.add(label);
        sliderBox.setBorder(BorderFactory.createTitledBorder(text));
        return sliderBox;
    }

    public void stateChanged(ChangeEvent e) {
        if (!this.updating) {
            this.color = new Color(this.redSlider.getValue(), this.greenSlider.getValue(), this.blueSlider.getValue(), this.withAlpha ? this.alphaSlider.getValue() : 255);
            if (this.changeListener != null) {
                this.changeListener.stateChanged(new ChangeEvent(this));
            }
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListener = ChangeEventMulticaster.add(this.changeListener, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListener = ChangeEventMulticaster.remove(this.changeListener, listener);
    }

    public void setColor(Color c) {
        if (!this.color.equals(c)) {
            this.updating = true;
            this.redSlider.setValue(c.getRed());
            this.greenSlider.setValue(c.getGreen());
            this.blueSlider.setValue(c.getBlue());
            if (this.withAlpha) {
                this.alphaSlider.setValue(c.getAlpha());
            }
            this.updating = false;
            this.color = c;
        }
    }

    public Color getColor() {
        return this.color;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("SimpleColorChooser");
        SimpleColorChooser scc = new SimpleColorChooser();
        f.getContentPane().add(scc);
        f.pack();
        f.setVisible(true);
    }
}

