/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.beans;

import de.jtem.beans.EditorManager;
import de.jtem.beans.EnumEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.Customizer;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class Inspector
extends JPanel {
    private static final long serialVersionUID = -6527245644109661448L;
    Class type;
    ArrayList<PropertyEditor> editors = new ArrayList();
    ArrayList<PropertyDescriptor> properties = new ArrayList();
    private boolean reading;
    private Object currObject;
    HashSet currentProperties = new HashSet();
    ChangeListener changeListener;
    private Collection excludedPropertyNames;
    private Customizer customizer = null;

    public Inspector(Object o, Collection excludedPropertyNames) throws IntrospectionException {
        BeanDescriptor bd;
        boolean hasCustomizer;
        this.setBorder(new EmptyBorder(10, 10, 10, 0));
        if (o == null) {
            throw new NullPointerException("object==null");
        }
        this.type = o.getClass();
        this.currObject = o;
        this.excludedPropertyNames = excludedPropertyNames;
        BeanInfo bi = null;
        if (Proxy.isProxyClass(o.getClass())) {
            LinkedList<BeanInfo> bis = new LinkedList<BeanInfo>();
            for (Class<?> interf : o.getClass().getInterfaces()) {
                String name = interf.getName() + "BeanInfo";
                try {
                    bis.add((BeanInfo)o.getClass().getClassLoader().loadClass(name).newInstance());
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (bis.size() > 0) {
                bi = (BeanInfo)bis.getFirst();
            }
        }
        if (bi == null) {
            bi = Introspector.getBeanInfo(this.type);
        }
        boolean bl = hasCustomizer = (bd = bi.getBeanDescriptor()) != null && bd.getCustomizerClass() != null;
        if (hasCustomizer) {
            Class<?> customizerClass = bd.getCustomizerClass();
            try {
                this.customizer = (Customizer)customizerClass.newInstance();
                this.setLayout(new BorderLayout());
                this.customizer.setObject(o);
                this.customizer.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent e) {
                        if (Inspector.this.changeListener != null) {
                            Inspector.this.changeListener.stateChanged(new ChangeEvent(Inspector.this.currObject));
                        }
                    }
                });
                this.add((Component)((Object)this.customizer));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            PropertyDescriptor[] pd = bi.getPropertyDescriptors();
            this.setLayout(new GridBagLayout());
            GridBagConstraints label = new GridBagConstraints();
            label.anchor = 13;
            label.ipadx = 5;
            GridBagConstraints editor = new GridBagConstraints();
            editor.fill = 1;
            editor.anchor = 10;
            editor.weightx = 1.0;
            editor.gridwidth = 0;
            int num = pd.length;
            for (int ix = 0; ix < num; ++ix) {
                try {
                    PropertyEditor pe;
                    Component c;
                    PropertyDescriptor descriptor = pd[ix];
                    if (excludedPropertyNames.contains(descriptor.getName()) || (c = this.editorComponent(pe = this.editor(descriptor), descriptor)) == null) continue;
                    JLabel l = new JLabel(descriptor.getDisplayName());
                    l.setLabelFor(c);
                    String sd = descriptor.getShortDescription();
                    if (sd != null && !sd.equals(descriptor.getDisplayName())) {
                        l.setToolTipText(sd);
                    }
                    this.properties.add(pd[ix]);
                    this.editors.add(pe);
                    this.add((Component)l, label);
                    this.add(c, editor);
                    final Method m = descriptor.getWriteMethod();
                    if (m == null) continue;
                    pe.addPropertyChangeListener(new PropertyChangeListener(){

                        public void propertyChange(PropertyChangeEvent evt) {
                            if (!Inspector.this.reading) {
                                try {
                                    m.invoke(Inspector.this.currObject, pe.getValue());
                                    if (Inspector.this.changeListener != null) {
                                        Inspector.this.changeListener.stateChanged(new ChangeEvent(Inspector.this.currObject));
                                    }
                                }
                                catch (IllegalArgumentException e) {
                                    e.printStackTrace();
                                }
                                catch (IllegalAccessException e) {
                                    e.printStackTrace();
                                }
                                catch (InvocationTargetException e) {
                                    e.getTargetException().printStackTrace();
                                }
                            }
                        }
                    });
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            editor.weighty = 1.0;
            this.add((Component)new JLabel(), editor);
        }
        this.refresh();
    }

    public Object getObject() {
        return this.currObject;
    }

    public Collection getExcludedPropertyNames() {
        return this.excludedPropertyNames;
    }

    void setObject(Object o) {
        if (o == this.currObject) {
            return;
        }
        this.currObject = o;
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        this.reading = true;
        try {
            if (!this.type.isInstance(this.currObject)) {
                throw new IllegalArgumentException();
            }
            if (this.customizer != null) {
                this.customizer.setObject(this.currObject);
            } else {
                int n = this.properties.size();
                for (int ix = 0; ix < n; ++ix) {
                    try {
                        PropertyDescriptor pd = this.properties.get(ix);
                        Method m = pd.getReadMethod();
                        if (m == null) continue;
                        PropertyEditor pe = this.editors.get(ix);
                        pe.setValue(m.invoke(this.currObject, (Object[])null));
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        finally {
            this.reading = false;
        }
    }

    private PropertyEditor editor(PropertyDescriptor descriptor) {
        PropertyEditor pe = EditorManager.findEditor(descriptor);
        if (pe == null) {
            if (descriptor.getPropertyType() == null) {
                System.out.println("descriptor.getPropertyType() == null");
                System.out.println("desc: " + descriptor.getName());
            }
            if (descriptor.getPropertyType() != null && descriptor.getPropertyType().isEnum()) {
                pe = new EnumEditor(descriptor.getPropertyType());
            }
        }
        return pe;
    }

    private Component editorComponent(PropertyEditor pe, PropertyDescriptor pd) {
        String sd;
        Component c;
        boolean editable;
        if (pe == null) {
            return null;
        }
        boolean bl = editable = pd.getWriteMethod() != null;
        if (pe.supportsCustomEditor() && editable) {
            c = pe.getCustomEditor();
            if (c instanceof JComponent) {
                ((JComponent)c).setEnabled(editable);
            }
        } else {
            String[] tags = pe.getTags();
            c = tags != null ? this.choices(pe, tags, editable) : this.textual(pe, editable);
        }
        if ((sd = pd.getShortDescription()) != null && !sd.equals(pd.getDisplayName()) && c instanceof JComponent) {
            ((JComponent)c).setToolTipText(sd);
        }
        return c;
    }

    private Component textual(final PropertyEditor pe, boolean editable) {
        final JTextField tf = new JTextField();
        pe.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Object o = evt.getNewValue();
                if (o == null) {
                    o = pe.getValue();
                }
                tf.setText(o == null ? "" : o.toString());
            }
        });
        tf.setEditable(editable);
        if (editable) {
            tf.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    pe.setAsText(tf.getText());
                }
            });
        }
        return tf;
    }

    private Component choices(final PropertyEditor pe, String[] tags, boolean editable) {
        final JComboBox<String> cb = new JComboBox<String>(tags);
        pe.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String o = pe.getAsText();
                cb.setSelectedItem(o == null ? "" : o);
            }
        });
        cb.setEditable(false);
        cb.setEnabled(editable);
        if (editable) {
            cb.getModel().addListDataListener(new ListDataListener(){

                public void contentsChanged(ListDataEvent e) {
                    if (Math.min(e.getIndex0(), e.getIndex1()) < 0) {
                        pe.setAsText((String)cb.getSelectedItem());
                    }
                }

                public void intervalAdded(ListDataEvent e) {
                }

                public void intervalRemoved(ListDataEvent e) {
                }
            });
        }
        return cb;
    }
}

