/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.beans;

import de.jtem.beans.AbstractDialog;
import de.jtem.beans.FontSelectionPanel;
import java.awt.Font;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JLabel;

public class FontDialog
extends AbstractDialog {
    private static final long serialVersionUID = 3534226596203732979L;
    private static Font defaultFont = new JLabel().getFont();
    private boolean updating = false;
    private static FontDialog sharedInstance;
    protected FontSelectionPanel fsp;

    public FontDialog(Font font) {
        this.fsp = new FontSelectionPanel(font);
        this.fsp.addObserver(new Observer(){

            public void update(Observable arg0, Object arg1) {
                if (!FontDialog.this.updating) {
                    FontDialog.this.fireStateChanged();
                }
            }
        });
        this.setMainComponent(this.fsp);
        this.pack();
        try {
            this.fsp.setSelectedFont(font);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Font getValue() {
        Font font = null;
        try {
            font = this.fsp.getSelectedFont();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return font;
    }

    public void setValue(Object o) {
        Font font = o instanceof Font ? (Font)o : defaultFont;
        this.updating = true;
        this.fsp.setSelectedFont(font);
        this.updating = false;
    }

    public static FontDialog sharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new FontDialog(defaultFont);
        }
        return sharedInstance;
    }

    public static Font getDefaultFont() {
        return defaultFont;
    }

    public static void setDefaultFont(Font defaultFont) {
        FontDialog.defaultFont = defaultFont;
    }
}

