/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.beans;

import de.jtem.beans.BoolEditor;
import de.jtem.beans.BooleanEditor;
import de.jtem.beans.ColorEditor;
import de.jtem.beans.DoubleSpinnerEditor;
import de.jtem.beans.DoubleTypeSpinnerEditor;
import de.jtem.beans.FloatEditor;
import de.jtem.beans.FontEditor;
import de.jtem.beans.IntegerSpinnerEditor;
import de.jtem.beans.IntegerTypeSpinnerEditor;
import de.jtem.beans.StringEditor;
import de.jtem.beans.StrokeEditor;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.util.HashMap;
import java.util.HashSet;

public class EditorManager {
    private static HashMap<Class, Class> registry = new HashMap();
    private static HashSet<Class> ignoredTypes = new HashSet();

    public static void registerIgnoredType(Class ignoredType) {
        ignoredTypes.add(ignoredType);
    }

    public static void registerEditor(Class targetType, Class editorClass) {
        if (editorClass == null) {
            registry.remove(targetType);
        } else {
            registry.put(targetType, editorClass);
        }
    }

    public static synchronized PropertyEditor findEditor(Class targetType) {
        if (ignoredTypes.contains(targetType)) {
            return null;
        }
        Class editorClass = registry.get(targetType);
        if (editorClass != null) {
            try {
                Object o = editorClass.newInstance();
                return (PropertyEditor)o;
            }
            catch (Exception ex) {
                System.err.println("Couldn't instantiate type editor \"" + editorClass.getName() + "\" : " + ex);
            }
        }
        try {
            String editorName = targetType.getName() + "Editor";
            return (PropertyEditor)Class.forName(editorName).newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static PropertyEditor findEditor(PropertyDescriptor descriptor) {
        Class<?> propertyType = descriptor.getPropertyType();
        if (ignoredTypes.contains(propertyType)) {
            return null;
        }
        PropertyEditor pe = EditorManager.findEditor(propertyType);
        Class<?> edcl = descriptor.getPropertyEditorClass();
        if (edcl != null) {
            try {
                pe = (PropertyEditor)edcl.newInstance();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return pe;
    }

    static {
        EditorManager.registerEditor(Boolean.TYPE, BoolEditor.class);
        EditorManager.registerEditor(Boolean.class, BooleanEditor.class);
        EditorManager.registerEditor(String.class, StringEditor.class);
        EditorManager.registerEditor(Color.class, ColorEditor.class);
        EditorManager.registerEditor(Stroke.class, StrokeEditor.class);
        EditorManager.registerEditor(Paint.class, ColorEditor.WithNullOption.class);
        EditorManager.registerEditor(Font.class, FontEditor.class);
        EditorManager.registerEditor(Integer.class, IntegerSpinnerEditor.class);
        EditorManager.registerEditor(Integer.TYPE, IntegerTypeSpinnerEditor.class);
        EditorManager.registerEditor(Double.class, DoubleSpinnerEditor.class);
        EditorManager.registerEditor(Double.TYPE, DoubleTypeSpinnerEditor.class);
        EditorManager.registerEditor(Float.class, FloatEditor.class);
        EditorManager.registerEditor(Float.TYPE, FloatEditor.class);
    }
}

