/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.beans;

import de.jtem.beans.AbstractDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.TextLayout;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorDialog
extends AbstractDialog
implements ChangeListener {
    private static final long serialVersionUID = 6560372785543938761L;
    private JSlider slider;
    private boolean updating = false;
    private JColorChooser colorChooser;
    private static ColorDialog instance = null;
    private AlphaPreviewPanel previewPanel;

    private ColorDialog(String title, Color color) {
        this.setTitle(title);
        JPanel content = new JPanel(new BorderLayout());
        this.colorChooser = color != null ? new JColorChooser(color) : new JColorChooser();
        this.previewPanel = new AlphaPreviewPanel(color);
        this.colorChooser.getSelectionModel().addChangeListener(this);
        JPanel panel = new JPanel();
        panel.add(this.previewPanel);
        panel.setBorder(new EmptyBorder(0, 0, 5, 0));
        this.colorChooser.setPreviewPanel(panel);
        content.add((Component)this.colorChooser, "Center");
        this.slider = new JSlider(0, 0, 255, color != null ? color.getAlpha() : 255);
        this.slider.setMajorTickSpacing(85);
        this.slider.setMinorTickSpacing(17);
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
        this.slider.setBorder(BorderFactory.createTitledBorder("Alpha"));
        this.slider.addChangeListener(this);
        content.add((Component)this.slider, "South");
        this.setMainComponent(content);
        this.pack();
    }

    public static ColorDialog sharedInstance() {
        if (instance == null) {
            instance = new ColorDialog("Choose Color", Color.RED);
        }
        return instance;
    }

    public void setValue(Object o) {
        this.updating = true;
        Color color = o instanceof Color ? (Color)o : Color.red;
        this.colorChooser.setColor(color);
        this.previewPanel.setColor(color);
        this.slider.setValue(color.getAlpha());
        this.updating = false;
    }

    public Color getValue() {
        Color chooser_color = this.colorChooser.getColor();
        return new Color(chooser_color.getRed(), chooser_color.getGreen(), chooser_color.getBlue(), this.slider.getValue());
    }

    public void stateChanged(ChangeEvent e) {
        if (!this.updating) {
            this.previewPanel.setColor(this.getValue());
            this.previewPanel.setColor(this.getValue());
            this.fireStateChanged();
        }
    }

    static class AlphaPreviewPanel
    extends JButton {
        private static final long serialVersionUID = -7614992473405869635L;
        private static final String text = "Black";
        private static final Font font = new Font("Sans Serif", 0, 30);
        private Color color;
        private Icon colorIcon = new Icon(){

            public void paintIcon(Component cmp, Graphics g, int x, int y) {
                Graphics2D g2d = (Graphics2D)g;
                g.setColor(Color.white);
                g.fillRect(x, y, AlphaPreviewPanel.this.getWidth(), AlphaPreviewPanel.this.getHeight());
                if (AlphaPreviewPanel.this.color != null) {
                    g.setColor(Color.black);
                    TextLayout tl = new TextLayout(AlphaPreviewPanel.text, font, g2d.getFontRenderContext());
                    Rectangle r = tl.getBounds().getBounds();
                    int height = r.height;
                    int width = r.width;
                    g2d.setFont(font);
                    int w = (this.getIconWidth() - width) / 2;
                    int h = (this.getIconHeight() - height) / 2;
                    g2d.drawString(AlphaPreviewPanel.text, x + w, y + height + h);
                    g.setColor(AlphaPreviewPanel.this.color);
                    g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
                }
                g.setColor(Color.black);
                g.drawRect(x, y, this.getIconWidth(), this.getIconHeight());
            }

            public int getIconWidth() {
                return AlphaPreviewPanel.this.getWidth();
            }

            public int getIconHeight() {
                return AlphaPreviewPanel.this.getHeight();
            }
        };

        AlphaPreviewPanel(Color color) {
            this.setEnabled(false);
            this.setPreferredSize(new Dimension(350, 50));
            this.setIcon(this.colorIcon);
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
            this.repaint();
        }
    }
}

