/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractDialog
extends JDialog {
    private static final long serialVersionUID = 5543689665195622291L;
    public static int BUTTON_NONE = 0;
    public static int BUTTON_OKAY = 1;
    public static int BUTTON_APPLY = 2;
    public static int BUTTON_CANCEL = 4;
    private ChangeListener changeListener;
    private ActionListener okListener;
    private ActionListener cancelListener;
    protected ApplyAction acApply = new ApplyAction();
    protected CancelAction acCancel = new CancelAction();
    protected OkayAction acOkay = new OkayAction();
    protected JPanel jpButtons;
    protected JPanel jpMain;
    private final ChangeEvent changeEvent = new ChangeEvent(this);

    public AbstractDialog(int buttons, JComponent component, boolean exitOnEnter) {
        this.jpMain = new JPanel();
        if (component != null) {
            this.setMainComponent(component);
        }
        this.jpButtons = new JPanel(new FlowLayout(2));
        if ((buttons & BUTTON_OKAY) > 0) {
            JButton jbOkay = new JButton(this.acOkay);
            this.jpButtons.add(jbOkay);
        }
        if ((buttons & BUTTON_APPLY) > 0) {
            this.jpButtons.add(new JButton(this.acApply));
        }
        if ((buttons & BUTTON_CANCEL) > 0) {
            JButton jbCancel = new JButton(this.acCancel);
            this.jpButtons.add(jbCancel);
        }
        JPanel jpFrame = new JPanel(new BorderLayout());
        jpFrame.setBorder(new EmptyBorder(5, 5, 5, 5));
        jpFrame.add((Component)this.jpMain, "Center");
        jpFrame.add((Component)this.jpButtons, "South");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jpFrame, "Center");
        this.setDefaultCloseOperation(0);
        this.setAlwaysOnTop(true);
        this.addWindowListener(new CloseListener());
        if (component != null) {
            this.pack();
        }
    }

    public abstract void setValue(Object var1);

    public abstract Object getValue();

    public AbstractDialog(int buttons, JComponent component) {
        this(buttons, component, true);
    }

    public AbstractDialog(int buttons) {
        this(buttons, null);
    }

    public AbstractDialog(int buttons, boolean exitOnEnter) {
        this(buttons, null, exitOnEnter);
    }

    public AbstractDialog() {
        this(BUTTON_OKAY | BUTTON_CANCEL);
    }

    public void apply() {
    }

    public void close() {
        this.setVisible(false);
    }

    public JPanel getButtonPanel() {
        return this.jpButtons;
    }

    public void setMainComponent(Component component) {
        this.getMainPanel().setLayout(new BorderLayout());
        this.getMainPanel().add(component, "Center");
    }

    public JPanel getMainPanel() {
        return this.jpMain;
    }

    public void show(Component c) {
        if (c != null) {
            this.setLocationRelativeTo(c);
        }
        this.setVisible(true);
    }

    protected void fireStateChanged() {
        if (this.changeListener != null) {
            this.changeListener.stateChanged(this.changeEvent);
        }
    }

    public void setChangeListener(ChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    public void setCancelListener(ActionListener cancelListener) {
        this.cancelListener = cancelListener;
    }

    public void setOkListener(ActionListener okListener) {
        this.okListener = okListener;
    }

    private class CloseListener
    extends WindowAdapter {
        private CloseListener() {
        }

        public void windowClosing(WindowEvent evt) {
            ActionEvent e = new ActionEvent(this, 0, "cancel");
            if (AbstractDialog.this.cancelListener != null) {
                AbstractDialog.this.cancelListener.actionPerformed(e);
            }
        }
    }

    private class OkayAction
    extends AbstractAction {
        private static final long serialVersionUID = -3866052681450602086L;

        public OkayAction() {
            this.putValue("Name", "OK");
            this.putValue("ShortDescription", "Closes the dialog saving changes.");
            this.putValue("MnemonicKey", new Integer(79));
        }

        public void actionPerformed(ActionEvent event) {
            ActionEvent e = new ActionEvent(this, 0, "ok");
            if (AbstractDialog.this.okListener != null) {
                AbstractDialog.this.okListener.actionPerformed(e);
            }
            AbstractDialog.this.setVisible(false);
        }
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = -1881501043731518772L;

        public CancelAction() {
            this.putValue("Name", "Cancel");
            this.putValue("ShortDescription", "Closes the dialog without saving changes.");
        }

        public void actionPerformed(ActionEvent e) {
            if (AbstractDialog.this.cancelListener != null) {
                AbstractDialog.this.cancelListener.actionPerformed(e);
            }
            AbstractDialog.this.setVisible(false);
        }
    }

    private class ApplyAction
    extends AbstractAction {
        private static final long serialVersionUID = 3869645622411010713L;

        public ApplyAction() {
            this.putValue("Name", "Apply");
            this.putValue("ShortDescription", "Applies changes.");
        }

        public void actionPerformed(ActionEvent event) {
            try {
                AbstractDialog.this.apply();
            }
            catch (IllegalArgumentException e) {
                JOptionPane.showMessageDialog(AbstractDialog.this, e.getMessage(), "Illegal Value", 0);
            }
        }
    }
}

