/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.common.services;

import java.util.Collection;
import java.util.HashSet;
import org.dawb.common.services.IHardwareService;
import org.dawb.common.services.IImageService;
import org.dawb.common.services.ILoaderService;
import org.dawb.common.services.ISystemService;
import org.dawb.common.services.IThumbnailService;
import org.dawb.common.services.IUserInputService;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.PlatformUI;

public class ServiceManager {
    private static final Collection<Class<? extends Object>> OFFLINE_SERVICES = new HashSet<Class<? extends Object>>(4);

    static {
        OFFLINE_SERVICES.add(IHardwareService.class);
        OFFLINE_SERVICES.add(ILoaderService.class);
        OFFLINE_SERVICES.add(IThumbnailService.class);
        OFFLINE_SERVICES.add(IUserInputService.class);
        OFFLINE_SERVICES.add(IImageService.class);
        OFFLINE_SERVICES.add(ISystemService.class);
    }

    public static Object getService(Class clazz) throws Exception {
        IConfigurationElement[] iConfigurationElementArray;
        if (PlatformUI.isWorkbenchRunning()) {
            return PlatformUI.getWorkbench().getService(clazz);
        }
        if (!OFFLINE_SERVICES.contains(clazz)) {
            throw new Exception("Cannot get an implementor for " + clazz + " in headless mode!");
        }
        IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui.services");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
            Object object = iConfigurationElement.createExecutableExtension("factoryClass");
            if (object != null && object.getClass() == clazz) {
                return object;
            }
            ++n2;
        }
        return null;
    }
}

