/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.ui.utils;

import java.io.File;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import uk.ac.gda.ui.utils.ResourceFilterWrapper;

public class ProjectUtils {
    public static IProject createImportProjectAndFolder(final String projectName, final String folderName, final String importFolder, final String natureId, final List<ResourceFilterWrapper> resourceFilterWrappers, IProgressMonitor monitor) throws CoreException {
        File file = new File(importFolder);
        if (!file.exists()) {
            throw new CoreException((IStatus)new Status(4, "uk.ac.gda.common.rcp", "Unable to create project folder " + projectName + "." + folderName + " as folder " + importFolder + " does not exist "));
        }
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IWorkspaceRoot root = workspace.getRoot();
                IProject project = root.getProject(projectName);
                if (!project.exists()) {
                    monitor.subTask("Creating project :" + projectName);
                    project.create(monitor);
                    if (natureId != null) {
                        project.open(monitor);
                        IProjectDescription description = project.getDescription();
                        description.setNatureIds(new String[]{natureId});
                        project.setDescription(description, monitor);
                    }
                }
                project.open(monitor);
                if (project.findMember(folderName) == null) {
                    IFolder src = project.getFolder(folderName);
                    src.createLink((IPath)new Path(importFolder), 128, monitor);
                    if (resourceFilterWrappers != null) {
                        for (ResourceFilterWrapper wrapper : resourceFilterWrappers) {
                            src.createFilter(wrapper.type, wrapper.fileInfoMatcherDescription, 128, monitor);
                        }
                    }
                }
            }
        };
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        workspace.run(runnable, workspace.getRuleFactory().modifyRule((IResource)root), 0, monitor);
        return root.getProject(projectName);
    }

    public static void addRemoveNature(IProject project, IProgressMonitor monitor, boolean add, String natureId) throws CoreException {
        IProjectDescription description = project.getDescription();
        boolean hasNature = project.hasNature(natureId);
        String[] newNatures = null;
        if (add) {
            if (!hasNature) {
                String[] natures = description.getNatureIds();
                newNatures = new String[natures.length + 1];
                System.arraycopy(natures, 0, newNatures, 0, natures.length);
                newNatures[natures.length] = natureId;
            }
        } else if (hasNature) {
            String[] natures = description.getNatureIds();
            Vector<String> v_newNatures = new Vector<String>();
            int i = 0;
            while (i < natures.length) {
                if (!natures[i].equals(natureId)) {
                    v_newNatures.add(natures[i]);
                }
                ++i;
            }
            newNatures = v_newNatures.toArray(new String[0]);
        }
        if (newNatures != null) {
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
        }
    }
}

