/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.ui.status;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class LinkContributionItem
extends ContributionItem {
    private static final int DEFAULT_CHAR_WIDTH = 40;
    private int charWidth;
    private CLabel link;
    private Composite statusLine = null;
    private String text = "";
    private int widthHint = -1;
    private int heightHint = -1;
    private MouseListener mouseListener;
    private Image image;
    private String tooltip;

    public LinkContributionItem(String id) {
        this(id, 40);
    }

    public LinkContributionItem(String id, int charWidth) {
        super(id);
        this.charWidth = charWidth;
        this.setVisible(false);
    }

    public void fill(Composite parent) {
        this.statusLine = parent;
        Label sep = new Label(parent, 2);
        this.link = new CLabel(this.statusLine, 32);
        if (this.mouseListener != null) {
            this.link.addMouseListener(this.mouseListener);
        }
        if (this.image != null) {
            this.link.setImage(this.image);
        }
        if (this.tooltip != null) {
            this.link.setToolTipText(this.tooltip);
        }
        if (this.widthHint < 0) {
            GC gc = new GC((Drawable)this.statusLine);
            gc.setFont(this.statusLine.getFont());
            FontMetrics fm = gc.getFontMetrics();
            this.widthHint = fm.getAverageCharWidth() * this.charWidth;
            this.heightHint = fm.getHeight();
            gc.dispose();
        }
        StatusLineLayoutData data = new StatusLineLayoutData();
        data.widthHint = this.widthHint;
        this.link.setLayoutData((Object)data);
        this.link.setText(this.text);
        data = new StatusLineLayoutData();
        data.heightHint = this.heightHint;
        sep.setLayoutData((Object)data);
    }

    public Point getDisplayLocation() {
        if (this.link != null && this.statusLine != null) {
            return this.statusLine.toDisplay(this.link.getLocation());
        }
        return null;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        Assert.isNotNull((Object)text);
        this.text = this.escape(text);
        if (this.link != null && !this.link.isDisposed()) {
            this.link.setText(this.text);
        }
        this.updateManager();
    }

    private void updateManager() {
        if (this.text.length() == 0) {
            if (this.isVisible()) {
                this.setVisible(false);
                IContributionManager contributionManager = this.getParent();
                if (contributionManager != null) {
                    contributionManager.update(true);
                }
            }
        } else if (!this.isVisible()) {
            this.setVisible(true);
            IContributionManager contributionManager = this.getParent();
            if (contributionManager != null) {
                contributionManager.update(true);
            }
        }
    }

    private String escape(String text) {
        return Util.replaceAll((String)text, (String)"&", (String)"&&");
    }

    public void setToolTipText(String txt) {
        Assert.isNotNull((Object)this.text);
        this.tooltip = this.escape(txt);
        if (this.link != null && !this.link.isDisposed()) {
            this.link.setToolTipText(txt);
        }
        this.updateManager();
    }

    public void setImage(Image image) {
        this.image = image;
        if (this.link != null && !this.link.isDisposed()) {
            this.link.setImage(image);
        }
        this.updateManager();
    }

    public void addMouseListener(MouseListener l) {
        if (this.link != null) {
            this.link.addMouseListener(l);
            this.mouseListener = null;
        } else {
            this.mouseListener = l;
        }
    }
}

