/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.ui.preferences;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import uk.ac.gda.richbeans.components.scalebox.ScaleBox;

public class ScaleBoxFieldEditor
extends FieldEditor {
    public static final int VALIDATE_ON_KEY_STROKE = 0;
    public static final int VALIDATE_ON_FOCUS_LOST = 1;
    public static int UNLIMITED = -1;
    private boolean isValid;
    protected double oldValue;
    ScaleBox scaleBox;
    private int widthInChars = UNLIMITED;
    private String errorMessage;
    private boolean emptyStringAllowed = true;
    private int validateStrategy = 0;

    protected ScaleBoxFieldEditor() {
    }

    public ScaleBoxFieldEditor(String name, String labelText, int width, int strategy, Composite parent) {
        this.init(name, labelText);
        this.widthInChars = width;
        this.setValidateStrategy(strategy);
        this.isValid = false;
        this.errorMessage = JFaceResources.getString((String)"StringFieldEditor.errorMessage");
        this.createControl(parent);
    }

    public ScaleBoxFieldEditor(String name, String labelText, int width, Composite parent) {
        this(name, labelText, width, 0, parent);
    }

    public ScaleBoxFieldEditor(String name, String labelText, Composite parent) {
        this(name, labelText, UNLIMITED, parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        GridData gd = (GridData)this.scaleBox.getLayoutData();
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = gd.horizontalSpan == 1;
    }

    protected boolean checkState() {
        boolean result = false;
        if (this.emptyStringAllowed) {
            result = true;
        }
        if (this.scaleBox == null) {
            result = false;
        }
        boolean bl = result = result && this.doCheckState();
        if (result) {
            this.clearErrorMessage();
        } else {
            this.showErrorMessage(this.errorMessage);
        }
        return result;
    }

    protected boolean doCheckState() {
        return true;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelControl(parent);
        this.scaleBox = this.getScaleBoxControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns - 1;
        if (this.widthInChars != UNLIMITED) {
            GC gc = new GC((Drawable)this.scaleBox);
            try {
                Point extent = gc.textExtent("X");
                gd.widthHint = this.widthInChars * extent.x;
            }
            finally {
                gc.dispose();
            }
        } else {
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
        }
        this.scaleBox.setLayoutData(gd);
    }

    protected void doLoad() {
        if (this.scaleBox != null) {
            double value = this.getPreferenceStore().getDouble(this.getPreferenceName());
            this.scaleBox.setValue(value);
            this.oldValue = value;
        }
    }

    protected void doLoadDefault() {
        if (this.scaleBox != null) {
            double value = this.getPreferenceStore().getDefaultDouble(this.getPreferenceName());
            this.scaleBox.setValue(value);
        }
        this.valueChanged();
    }

    protected void doStore() {
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.scaleBox.getNumericValue());
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getNumberOfControls() {
        return 2;
    }

    public ScaleBox getControl() {
        return this.scaleBox;
    }

    public ScaleBox getScaleBoxControl(Composite parent) {
        if (this.scaleBox == null) {
            this.scaleBox = new ScaleBox(parent, 0);
            this.scaleBox.on();
            this.scaleBox.setFont(parent.getFont());
            switch (this.validateStrategy) {
                case 0: {
                    this.scaleBox.addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyReleased(KeyEvent e) {
                            ScaleBoxFieldEditor.this.valueChanged();
                        }
                    });
                    this.scaleBox.addFocusListener((FocusListener)new FocusAdapter(){

                        public void focusLost(FocusEvent e) {
                            ScaleBoxFieldEditor.this.valueChanged();
                        }
                    });
                    break;
                }
                case 1: {
                    this.scaleBox.addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyPressed(KeyEvent e) {
                            ScaleBoxFieldEditor.this.clearErrorMessage();
                        }
                    });
                    this.scaleBox.addFocusListener((FocusListener)new FocusAdapter(){

                        public void focusGained(FocusEvent e) {
                            ScaleBoxFieldEditor.this.refreshValidState();
                        }

                        public void focusLost(FocusEvent e) {
                            ScaleBoxFieldEditor.this.valueChanged();
                            ScaleBoxFieldEditor.this.clearErrorMessage();
                        }
                    });
                    break;
                }
                default: {
                    Assert.isTrue((boolean)false, (String)"Unknown validate strategy");
                }
            }
            this.scaleBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    ScaleBoxFieldEditor.this.scaleBox = null;
                }
            });
        } else {
            this.checkParent((Control)this.scaleBox, parent);
        }
        return this.scaleBox;
    }

    public boolean isEmptyStringAllowed() {
        return this.emptyStringAllowed;
    }

    public boolean isValid() {
        return this.isValid;
    }

    protected void refreshValidState() {
        this.isValid = this.checkState();
    }

    public void setEmptyStringAllowed(boolean b) {
        this.emptyStringAllowed = b;
    }

    public void setErrorMessage(String message) {
        this.errorMessage = message;
    }

    public void setFocus() {
        if (this.scaleBox != null) {
            this.scaleBox.setFocus();
        }
    }

    public void setValidateStrategy(int value) {
        Assert.isTrue((value == 1 || value == 0 ? 1 : 0) != 0);
        this.validateStrategy = value;
    }

    public void showErrorMessage() {
        this.showErrorMessage(this.errorMessage);
    }

    protected void valueChanged() {
        double newValue;
        this.setPresentsDefaultValue(false);
        boolean oldState = this.isValid;
        this.refreshValidState();
        if (this.isValid != oldState) {
            this.fireStateChanged("field_editor_is_valid", oldState, this.isValid);
        }
        if ((newValue = this.scaleBox.getNumericValue()) != this.oldValue) {
            this.fireValueChanged("field_editor_value", this.oldValue, newValue);
            this.oldValue = newValue;
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.scaleBox.setEnabled(enabled);
    }
}

