/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.ui.file;

import com.swtdesigner.SWTResourceManager;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import uk.ac.gda.common.rcp.util.IFileUtils;
import uk.ac.gda.util.io.FileUtils;

public class IFileTreeLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private boolean isDisposed = false;
    private final Image folderImage;
    private final Image fileImage;
    private final Image nexusImage;
    private final Image asciiImage;
    private final DateFormat dateFormat;
    private final int[] flags;

    public IFileTreeLabelProvider() {
        this(2, 8);
    }

    public IFileTreeLabelProvider(int ... flags) {
        this.flags = flags;
        this.folderImage = SWTResourceManager.getImage(IFileTreeLabelProvider.class, "/icons/folder.png");
        this.fileImage = SWTResourceManager.getImage(IFileTreeLabelProvider.class, "/icons/page.png");
        this.nexusImage = SWTResourceManager.getImage(IFileTreeLabelProvider.class, "/icons/nexus.png");
        this.asciiImage = SWTResourceManager.getImage(IFileTreeLabelProvider.class, "/icons/page_white_database.png");
        this.dateFormat = new SimpleDateFormat("EEE dd MMM yyyy HH:mm:ss z");
    }

    private Image getImageFromFile(IResource file) {
        if (this.isDisposed()) {
            return null;
        }
        if (!file.exists()) {
            return null;
        }
        if (file instanceof IContainer) {
            return this.folderImage;
        }
        if (file.getName().toLowerCase().endsWith(".nxs")) {
            return this.nexusImage;
        }
        if (file.getName().toLowerCase().endsWith(".dat")) {
            return this.asciiImage;
        }
        return this.fileImage;
    }

    private String getTextFromFile(IResource element) {
        return element.getName();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImageFromFile((IResource)element);
        }
        int flag = this.flags[columnIndex - 1];
        if (flag == 4) {
            return this.folderImage;
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        IResource file = (IResource)element;
        if (!file.exists()) {
            return null;
        }
        if (columnIndex == 0) {
            return this.getTextFromFile(file);
        }
        int flag = this.flags[columnIndex - 1];
        if (flag == 8) {
            return this.getDate(element);
        }
        if (flag == 2) {
            return this.getSize(element);
        }
        if (flag == 4) {
            return this.getPath(element);
        }
        return null;
    }

    public String getSize(Object element) {
        try {
            return FileUtils.formatSize((long)IFileUtils.getLength((IResource)element), (int)3);
        }
        catch (Exception exception) {
            return "-";
        }
    }

    public String getDate(Object element) {
        try {
            return this.dateFormat.format(new Date(IFileUtils.getLastModified((IResource)element)));
        }
        catch (Exception exception) {
            return "-";
        }
    }

    public String getPath(Object element) {
        IResource res = (IResource)element;
        return res.getParent().getFullPath().toOSString();
    }

    public void dispose() {
        this.isDisposed = true;
        super.dispose();
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }
}

