/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.ui.file;

import java.util.Collection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import uk.ac.gda.common.rcp.util.ISortingUtils;

public class IFileTreeContentProvider
implements ITreeContentProvider {
    private IResource rootFile;

    public IFileTreeContentProvider(IResource r) {
        this.rootFile = r;
    }

    public void setPath(IResource r) {
        this.rootFile = r;
    }

    public IResource getPath() {
        return this.rootFile;
    }

    public Object[] getChildren(Object parentElement) {
        Collection<IResource> sortedFiles;
        IResource parFile = (IResource)parentElement;
        if (!parFile.exists()) {
            return null;
        }
        if (!(parFile instanceof IContainer)) {
            return null;
        }
        try {
            sortedFiles = ISortingUtils.getSortedFileListIgnoreHidden((IContainer)parFile, ISortingUtils.NATURAL_COMPARATOR);
        }
        catch (CoreException coreException) {
            return null;
        }
        if (sortedFiles == null) {
            return new Object[0];
        }
        return sortedFiles.toArray(new IResource[sortedFiles.size()]);
    }

    public Object getParent(Object element) {
        if (element.equals(this.rootFile)) {
            return null;
        }
        return ((IResource)element).getParent();
    }

    public boolean hasChildren(Object element) {
        IResource parFile = (IResource)element;
        if (!(parFile instanceof IContainer)) {
            return false;
        }
        if (!parFile.exists()) {
            return false;
        }
        if (parFile.isHidden()) {
            return false;
        }
        if (parFile.isPhantom()) {
            return false;
        }
        if (parFile.getLocation().toFile().isHidden()) {
            return false;
        }
        if (!parFile.isAccessible()) {
            return false;
        }
        IContainer container = (IContainer)parFile;
        try {
            IResource[] members = container.members();
            return members != null && members.length > 0;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof Object[]) {
            return (Object[])inputElement;
        }
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

