/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.ui.file;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import uk.ac.gda.common.rcp.util.IFileUtils;
import uk.ac.gda.util.io.FileUtils;

public class IFileTreeColumnProvider
extends CellLabelProvider {
    private SimpleDateFormat dateFormat = new SimpleDateFormat("EEE dd MMM yyyy HH:mm:ss z");

    public void update(ViewerCell cell) {
    }

    public String getToolTipText(Object element) {
        String path = this.getFilePath(element);
        if (path == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(path);
        buf.append('\n');
        try {
            buf.append(FileUtils.formatSize((long)this.getLength(element), (int)3));
            buf.append('\n');
            buf.append(this.dateFormat.format(new Date(this.getLastModified(element))));
        }
        catch (Exception exception) {}
        return buf.toString();
    }

    private long getLength(Object element) throws Exception {
        if (element == null) {
            return 0L;
        }
        if (element instanceof File) {
            File file = (File)element;
            if (!file.exists()) {
                return 0L;
            }
            return file.length();
        }
        if (element instanceof IResource) {
            IFileUtils.getLength((IResource)element);
        }
        return 0L;
    }

    private long getLastModified(Object element) throws Exception {
        if (element == null) {
            return 0L;
        }
        if (element instanceof File) {
            File file = (File)element;
            if (!file.exists()) {
                return 0L;
            }
            return file.length();
        }
        if (element instanceof IResource) {
            IFileUtils.getLastModified((IResource)element);
        }
        return 0L;
    }

    private String getFilePath(Object element) {
        if (element == null) {
            return null;
        }
        if (element instanceof File) {
            File file = (File)element;
            if (!file.exists()) {
                return null;
            }
            return file.getAbsolutePath();
        }
        if (element instanceof IResource) {
            IResource file = (IResource)element;
            if (!file.exists()) {
                return null;
            }
            return file.getLocation().toOSString();
        }
        return null;
    }
}

