/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.ui.doe;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.gda.doe.DOEUtils;
import uk.ac.gda.doe.RangeInfo;
import uk.ac.gda.ui.doe.DOEBeanProvider;
import uk.ac.gda.ui.doe.FieldColumnProvider;

public class DOEView
extends ViewPart {
    private static Logger logger = LoggerFactory.getLogger(DOEView.class);
    public static final String ID = "uk.ac.gda.ui.doe.DOEView";
    private TableViewer tableViewer;
    private List<RangeInfo> info;
    private DOEBeanProvider beansProvider;

    public DOEView() throws CoreException {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("uk.ac.common.doe.beans");
        if (config.length != 0) {
            IConfigurationElement e = iConfigurationElementArray[0];
            this.beansProvider = (DOEBeanProvider)e.createExecutableExtension("class");
        }
    }

    public void createPartControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        Table table = new Table(container, 101124);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 3;
        table.setLayoutData((Object)gridData);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setContentProvider(this.createContentProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer, (int)2);
        this.createRightClickMenu();
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DOEView.this.refresh();
            }
        });
    }

    private void createTableColumns() {
        while (this.tableViewer.getTable().getColumnCount() > 1) {
            this.tableViewer.getTable().getColumns()[1].dispose();
        }
        if (this.tableViewer.getTable().getColumnCount() < 1) {
            TableViewerColumn col = new TableViewerColumn(this.tableViewer, 0, 0);
            col.getColumn().setText("Experiment");
            col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public void update(ViewerCell cell) {
                    TableItem item = (TableItem)cell.getViewerRow().getItem();
                    Table table = DOEView.this.tableViewer.getTable();
                    int row = table.indexOf(item) + 1;
                    cell.setText(" " + row);
                }
            });
            col.getColumn().setWidth(120);
        }
        if (this.info == null) {
            return;
        }
        LinkedHashMap columns = new LinkedHashMap();
        for (RangeInfo i : this.info) {
            columns.putAll(i.getColumnClasses());
        }
        String[] columnLabels = this.getColumnLabels(columns);
        String[] columnProperties = this.getColumnProperties(columns);
        int icolumn = 1;
        while (icolumn < columnLabels.length) {
            TableViewerColumn col = new TableViewerColumn(this.tableViewer, 0, icolumn);
            col.getColumn().setText(columnLabels[icolumn]);
            col.setLabelProvider((CellLabelProvider)new FieldColumnProvider(columnProperties));
            col.getColumn().setWidth(100);
            ++icolumn;
        }
        this.tableViewer.setColumnProperties(columnProperties);
        this.tableViewer.setInput(new Object());
    }

    private String[] getColumnLabels(Map<String, Class<?>> columns) {
        ArrayList<String> columnLabels = new ArrayList<String>(columns.size() + 1);
        columnLabels.add("Run");
        for (String name : columns.keySet()) {
            String label = this.beansProvider.getColumnLabel(name, columns.get(name));
            if (label == null) {
                label = name;
            }
            columnLabels.add(label);
        }
        return columnLabels.toArray(new String[columnLabels.size()]);
    }

    private String[] getColumnProperties(Map<String, Class<?>> columns) {
        ArrayList<String> columnNames = new ArrayList<String>(columns.size() + 1);
        columnNames.add("Run");
        for (String name : columns.keySet()) {
            columnNames.add(name);
        }
        return columnNames.toArray(new String[columnNames.size()]);
    }

    private IContentProvider createContentProvider() {
        return new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                try {
                    return DOEView.this.info.toArray(new RangeInfo[DOEView.this.info.size()]);
                }
                catch (Exception e) {
                    logger.error("Cannot get info from list", (Throwable)e);
                    return null;
                }
            }
        };
    }

    private void createInfo() throws Exception {
        List<Object> obs = this.beansProvider.getBeans();
        this.info = DOEUtils.getInfoFromList(obs);
    }

    public void setFocus() {
        this.tableViewer.getControl().setFocus();
    }

    private void createRightClickMenu() {
        MenuManager menuManager = new MenuManager();
        this.tableViewer.getControl().setMenu(menuManager.createContextMenu(this.tableViewer.getControl()));
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.tableViewer);
    }

    public void refresh() {
        try {
            this.createInfo();
            this.createTableColumns();
            this.tableViewer.refresh();
        }
        catch (Exception e) {
            logger.error("Cannot read ranges", (Throwable)e);
        }
    }
}

