/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.ui.dialog;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class VisitIDDialog
extends Dialog {
    protected TableViewer userTable;
    private String chosenVisitID = null;
    private String[][] visits;

    public VisitIDDialog(Display parent, String[][] visits) {
        super(new Shell(parent));
        this.visits = visits;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Choose a visit");
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        Label l = new Label(container, 0);
        l.setText("You can collect data under any of the following visits. Please select the visit you wish to use.");
        Table table = new Table(container, 101124);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        table.setLayoutData((Object)gridData);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.userTable = new TableViewer(table);
        this.userTable.setUseHashlookup(true);
        this.createTableColumns();
        this.createContentProvider();
        this.userTable.setInput((Object)this.visits);
        return container;
    }

    private void createTableColumns() {
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.userTable, (int)2);
        TableViewerColumn visitIDCol = new TableViewerColumn(this.userTable, 0, 0);
        TableColumn tableColumn = visitIDCol.getColumn();
        tableColumn.setAlignment(0x1000000);
        visitIDCol.getColumn().setText("Visit ID");
        visitIDCol.getColumn().setWidth(100);
        visitIDCol.setLabelProvider((CellLabelProvider)new VisitIDColumnLabelProvider(0));
        TableViewerColumn descriptionCol = new TableViewerColumn(this.userTable, 0, 1);
        descriptionCol.getColumn().setText("Title");
        descriptionCol.getColumn().setWidth(300);
        descriptionCol.setLabelProvider((CellLabelProvider)new VisitIDColumnLabelProvider(1));
    }

    private void createContentProvider() {
        this.userTable.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return VisitIDDialog.this.visits;
            }
        });
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(661, 300);
    }

    public String getChoosenID() {
        return this.chosenVisitID;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            if (this.userTable.getTable().getSelectionCount() != 1) {
                return;
            }
            if (this.userTable.getTable().getSelection().length != 1) {
                return;
            }
            TableItem choice = this.userTable.getTable().getSelection()[0];
            this.chosenVisitID = ((String[])choice.getData())[0];
        } else {
            this.chosenVisitID = null;
        }
        super.buttonPressed(buttonId);
    }

    private class VisitIDColumnLabelProvider
    extends ColumnLabelProvider {
        private int columnIndex;

        VisitIDColumnLabelProvider(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        public String getText(Object element) {
            if (element instanceof String[]) {
                return ((String[])element)[this.columnIndex];
            }
            return super.getText(element);
        }
    }
}

