/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.ui.content;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import uk.ac.gda.ui.content.IFilterExtensionProvider;

public class FileContentProposalProvider
implements IContentProposalProvider {
    private IFilterExtensionProvider filterExtensionProv;

    public IContentProposal[] getProposals(String contents, int position) {
        File dir = this.getDirectory(contents, position);
        if (dir == null) {
            return new IContentProposal[0];
        }
        IContentProposal[] ret = this.getProposals(contents, dir);
        if (ret == null) {
            return new IContentProposal[0];
        }
        return ret;
    }

    private IContentProposal[] getProposals(String existing, File dir) {
        File[] fa = dir.listFiles(new FilenameChecker());
        if (fa == null) {
            return null;
        }
        ArrayList<FileContentProposal> ret = new ArrayList<FileContentProposal>(fa.length);
        ret.add(new FileContentProposal(dir));
        int i = 0;
        while (i < fa.length) {
            block6: {
                File file = fa[i];
                try {
                    String path = file.getCanonicalPath();
                    int index = path.indexOf(existing);
                    if (index != 0) {
                    }
                }
                catch (IOException iOException) {}
                break block6;
                ret.add(new FileContentProposal(file));
            }
            ++i;
        }
        if (ret.isEmpty()) {
            return null;
        }
        return ret.toArray(new IContentProposal[ret.size()]);
    }

    private File getDirectory(String contents, int position) {
        int index;
        if (contents == null) {
            return null;
        }
        if (position > -1) {
            contents = contents.substring(0, position);
        }
        if ((index = contents.lastIndexOf(47)) < 0) {
            index = contents.lastIndexOf(92);
        }
        if (index > -1) {
            contents = contents.substring(0, index);
        }
        return new File(contents);
    }

    public IFilterExtensionProvider getFilterExtensionProv() {
        return this.filterExtensionProv;
    }

    public void setFilterExtensionProv(IFilterExtensionProvider filterExtensionProv) {
        this.filterExtensionProv = filterExtensionProv;
    }

    class FileContentProposal
    implements IContentProposal {
        private final File file;

        FileContentProposal(File file) {
            this.file = file;
        }

        public String getContent() {
            return this.getLabel();
        }

        public int getCursorPosition() {
            return this.getLabel().length();
        }

        public String getDescription() {
            return null;
        }

        public String getLabel() {
            return this.file.getAbsolutePath();
        }
    }

    private class FilenameChecker
    implements FileFilter {
        private FilenameChecker() {
        }

        @Override
        public boolean accept(File file) {
            if (file == null) {
                return true;
            }
            if (file.isDirectory()) {
                return true;
            }
            if (FileContentProposalProvider.this.filterExtensionProv == null) {
                return true;
            }
            String[] filters = FileContentProposalProvider.this.filterExtensionProv.getFilterExtensions();
            if (filters == null) {
                return true;
            }
            int i = 0;
            while (i < filters.length) {
                String filter = filters[i].replace(".", "\\.");
                filter = filters[i].replace("*", ".*");
                if (file.getName().matches(filter)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

