/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.ui.components;

import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.gda.richbeans.event.ValueEvent;
import uk.ac.gda.richbeans.event.ValueListener;
import uk.ac.gda.util.ThreadManager;

public abstract class QueuedCommandWidget
extends Composite {
    private static Logger logger = LoggerFactory.getLogger(QueuedCommandWidget.class);
    private static Thread mainQueueThread;
    private static BlockingQueue<QueuedCommandWidget> queue;
    protected Label label;
    protected Link runCommand;
    private SelectionAdapter selectionListener;
    protected Collection<ValueListener> listeners;
    protected String unit;

    public QueuedCommandWidget(Composite parent, int style) {
        super(parent, style);
        QueuedCommandWidget.initQueue();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        this.label = new Label((Composite)this, 0);
        this.runCommand = new Link((Composite)this, 0);
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String text = null;
                try {
                    text = QueuedCommandWidget.this.runCommand();
                }
                catch (Exception e1) {
                    MessageDialog.openError((Shell)QueuedCommandWidget.this.getShell(), (String)"Cannot Connect to Command", (String)e1.getMessage());
                }
                QueuedCommandWidget.this.setLabelText(text);
                QueuedCommandWidget.this.layout();
            }
        };
        this.runCommand.addSelectionListener((SelectionListener)this.selectionListener);
    }

    public void dispose() {
        this.runCommand.removeSelectionListener((SelectionListener)this.selectionListener);
        super.dispose();
    }

    protected static void initQueue() {
        if (queue == null) {
            queue = new ArrayBlockingQueue<QueuedCommandWidget>(3);
        }
        if (mainQueueThread == null) {
            mainQueueThread = ThreadManager.getThread((Runnable)QueuedCommandWidget.getRunnable(), (String)("QueuedCommandWidget thread. Used to updated all " + QueuedCommandWidget.class.getName() + "'s"));
            mainQueueThread.start();
        }
    }

    protected static void clear() {
        if (mainQueueThread != null) {
            try {
                mainQueueThread.interrupt();
            }
            catch (Exception exception) {}
        }
        mainQueueThread = null;
        queue.clear();
    }

    protected static Runnable getRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            QueuedCommandWidget req;
                            if (!QueuedCommandWidget.checkActive(req = (QueuedCommandWidget)((Object)queue.take()))) {
                                return;
                            }
                            final String status = req.runCommand();
                            if (req.isDisposed()) {
                                return;
                            }
                            req.getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    req.setLabelText(status);
                                    req.fireValueChangeListeners(status);
                                    req.layout();
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        logger.error("Cannot run command in " + QueuedCommandWidget.class.getName(), (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
        };
    }

    protected void fireValueChangeListeners(String status) {
        if (this.listeners == null) {
            return;
        }
        ValueEvent e = new ValueEvent((Object)this, null);
        e.setValue(status);
        for (ValueListener l : this.listeners) {
            l.valueChangePerformed(e);
        }
    }

    public void addValueChangeListener(ValueListener l) {
        if (this.listeners == null) {
            this.listeners = new HashSet<ValueListener>(3);
        }
        this.listeners.add(l);
    }

    protected static boolean checkActive(QueuedCommandWidget req) {
        if (Thread.currentThread().isInterrupted() || req.isDisposed()) {
            QueuedCommandWidget.clear();
            return false;
        }
        try {
            req.getDisplay().isDisposed();
        }
        catch (Exception exception) {
            QueuedCommandWidget.clear();
            return false;
        }
        return true;
    }

    protected abstract String runCommand() throws Exception;

    protected void checkSubclass() {
    }

    protected Link getRunCommand() {
        return this.runCommand;
    }

    protected Label getLabel() {
        return this.label;
    }

    public void setLinkText(String text) {
        this.runCommand.setText("<a>" + text + "</a>");
    }

    public void setLabelText(String status) {
        if (this.getUnit() == null) {
            this.label.setText(status);
        } else {
            this.label.setText(String.valueOf(status) + " " + this.getUnit());
        }
    }

    public void setLinkTooltip(String text) {
        this.runCommand.setToolTipText(text);
    }

    public void setLabelTooltip(String text) {
        this.label.setToolTipText(text);
    }

    public String getLinkText() {
        return this.runCommand.getText();
    }

    public String getLabelText() {
        return this.label.getText();
    }

    public String getLinkTooltip() {
        return this.runCommand.getToolTipText();
    }

    public String getLabelTooltip() {
        return this.label.getToolTipText();
    }

    public void updateValue() {
        try {
            QueuedCommandWidget.initQueue();
            queue.add(this);
        }
        catch (IllegalStateException illegalStateException) {}
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }
}

