/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.xml.string;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Status;

public class StringStorage
implements IStorage {
    private String string;
    private String name;

    public StringStorage(String input) {
        this(input, null);
    }

    public StringStorage(String input, String name) {
        this.string = input;
        this.name = name;
    }

    public InputStream getContents() throws CoreException {
        try {
            return new ByteArrayInputStream(this.string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            CoreException c = new CoreException(Status.CANCEL_STATUS);
            c.setStackTrace(e.getStackTrace());
            throw c;
        }
    }

    public IPath getFullPath() {
        return null;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        String[] lines = this.string.split("\n");
        String tag = lines[1].trim();
        return tag.substring(1, tag.length() - 2);
    }

    public boolean isReadOnly() {
        return true;
    }
}

