/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.xml;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.FileEditorInput;
import uk.ac.gda.common.rcp.util.EclipseUtils;
import uk.ac.gda.richbeans.xml.XMLBeanContentDescriberFactory;
import uk.ac.gda.richbeans.xml.string.StringInput;
import uk.ac.gda.richbeans.xml.string.StringStorage;

public class XMLEditorManager {
    public static void openXmlEditorsFromFiles(List<IFile> files) throws Exception {
        ArrayList<IStorageEditorInput> inputs = new ArrayList<IStorageEditorInput>(files.size());
        for (IFile file : files) {
            inputs.add((IStorageEditorInput)new FileEditorInput(file));
        }
        XMLEditorManager.openXmlEditors(inputs);
    }

    public static void openXmlEditorsFromStrings(List<String> files) throws Exception {
        ArrayList<IStorageEditorInput> inputs = new ArrayList<IStorageEditorInput>(files.size());
        for (String file : files) {
            inputs.add(new StringInput(new StringStorage(file)));
        }
        XMLEditorManager.openXmlEditors(inputs);
    }

    public static void openXmlEditors(List<IStorageEditorInput> files) throws Exception {
        IWorkbenchPage page = EclipseUtils.getActivePage();
        if (page == null) {
            throw new Exception("Active page not found!");
        }
        List<String> ids = XMLEditorManager.getIds(files);
        IEditorReference[] editors = page.getEditorReferences();
        ArrayList<String> checked = new ArrayList<String>(editors.length);
        int i = 0;
        while (i < editors.length) {
            String id = editors[i].getId();
            if (!ids.contains(id) || checked.contains(id)) {
                IEditorPart editor = editors[i].getEditor(false);
                if (editor.isDirty()) {
                    editor.doSave((IProgressMonitor)new NullProgressMonitor());
                }
                page.closeEditor(editor, false);
            }
            checked.add(id);
            ++i;
        }
        i = 0;
        while (i < files.size()) {
            IStorageEditorInput input = files.get(i);
            String id = ids.get(i);
            IEditorReference[] eds = page.findEditors(null, id, 2);
            if (eds != null && eds.length > 0) {
                int j = 0;
                while (j < eds.length) {
                    IEditorPart editor = eds[j].getEditor(false);
                    if (editor instanceof IReusableEditor) {
                        if (editor.isDirty()) {
                            editor.doSave((IProgressMonitor)new NullProgressMonitor());
                        }
                        page.reuseEditor((IReusableEditor)editor, (IEditorInput)input);
                        break;
                    }
                    ++j;
                }
            } else {
                page.openEditor((IEditorInput)input, id);
            }
            ++i;
        }
    }

    private static List<String> getIds(List<IStorageEditorInput> files) {
        ArrayList<String> ids = new ArrayList<String>(files.size());
        for (IStorageEditorInput file : files) {
            ids.add(XMLBeanContentDescriberFactory.getInstance().getId(file));
        }
        return ids;
    }
}

