/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.xml;

import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.ui.IStorageEditorInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.gda.common.rcp.util.IStorageUtils;
import uk.ac.gda.richbeans.xml.XMLBeanContentDescriber;

public class XMLBeanContentDescriberFactory {
    private static final Logger logger = LoggerFactory.getLogger(XMLBeanContentDescriberFactory.class);
    private static XMLBeanContentDescriberFactory factory = new XMLBeanContentDescriberFactory();
    private Collection<XMLBeanContentDescriber> contentList = Collections.newSetFromMap(new ConcurrentHashMap());
    private Map<String, String> extensionMap;

    private XMLBeanContentDescriberFactory() {
    }

    public static XMLBeanContentDescriberFactory getInstance() {
        return factory;
    }

    public void addDescriber(XMLBeanContentDescriber beanContentDescriber) {
        try {
            this.contentList.add(beanContentDescriber);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addFileExtension(String extension, String id) {
        if (this.extensionMap == null) {
            this.extensionMap = new ConcurrentHashMap<String, String>(3);
        }
        this.extensionMap.put(extension, id);
    }

    public String getId(IFile file) {
        if (this.extensionMap != null && file != null) {
            for (String extension : this.extensionMap.keySet()) {
                if (!file.getName().endsWith(extension)) continue;
                return this.extensionMap.get(extension);
            }
        }
        for (XMLBeanContentDescriber beanDes : this.contentList) {
            try {
                InputStream contents = IStorageUtils.getContents((IStorage)file);
                if (beanDes.describe(contents, null) != 2) continue;
                return beanDes.getEditorId();
            }
            catch (Exception e) {
                logger.error("Unexpected exception attempting to obtain Id", (Throwable)e);
            }
        }
        return "";
    }

    public String getId(IStorageEditorInput file) {
        for (XMLBeanContentDescriber beanDes : this.contentList) {
            try {
                InputStream contents = IStorageUtils.getContents(file.getStorage(), null);
                if (beanDes.describe(contents, null) != 2) continue;
                return beanDes.getEditorId();
            }
            catch (Exception e) {
                logger.error("Unexpected exception attempting to obtain Id", (Throwable)e);
            }
        }
        return "";
    }

    public boolean isId(String id) {
        if (id == null) {
            return false;
        }
        for (XMLBeanContentDescriber d : this.contentList) {
            if (!id.equals(d.getEditorId())) continue;
            return true;
        }
        return false;
    }
}

