/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.xml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescriber;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.ITextContentDescriber;
import uk.ac.gda.richbeans.xml.XMLBeanContentDescriberFactory;

public abstract class XMLBeanContentDescriber
implements IContentDescriber,
ITextContentDescriber {
    public XMLBeanContentDescriber() {
        XMLBeanContentDescriberFactory.getInstance().addDescriber(this);
    }

    protected abstract String getBeanName();

    protected abstract String getEditorId();

    public int describe(Reader contents, IContentDescription description) throws IOException {
        BufferedReader reader = new BufferedReader(contents);
        try {
            reader.readLine();
            String tagLine = reader.readLine();
            String tagName = this.getTagName();
            if (tagLine.trim().equalsIgnoreCase("<" + tagName + ">") || tagLine.trim().equalsIgnoreCase("<" + tagName + "/>")) {
                return 2;
            }
            return 0;
        }
        finally {
            reader.close();
        }
    }

    public int describe(InputStream contents, IContentDescription description) throws IOException {
        return this.describe(new InputStreamReader(contents, "UTF-8"), description);
    }

    private String getTagName() {
        String beanName = this.getBeanName();
        return beanName.substring(beanName.lastIndexOf(".") + 1);
    }

    public QualifiedName[] getSupportedOptions() {
        return IContentDescription.ALL;
    }
}

