/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.editors.xml.bean;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.ide.FileStoreEditorInput;
import uk.ac.gda.common.rcp.util.EclipseUtils;
import uk.ac.gda.richbeans.editors.xml.bean.XMLPartitionScanner;
import uk.ac.gda.util.io.FileUtils;

public class XMLDocumentProvider
extends FileDocumentProvider {
    private Document document;

    protected IDocument createDocument(Object element) throws CoreException {
        this.document = (Document)this.createEmptyDocument();
        this.setupDocument(element, (IDocument)this.document);
        if (this.document != null) {
            XMLPartitioner partitioner = new XMLPartitioner();
            partitioner.connect((IDocument)this.document);
            this.document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        }
        return this.document;
    }

    public IDocument getDocument(Object element) {
        if (element == null) {
            return this.document;
        }
        return super.getDocument(element);
    }

    public boolean isModifiable(Object element) {
        return true;
    }

    public boolean isReadOnly(Object element) {
        return false;
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        if (element instanceof FileStoreEditorInput) {
            IEditorInput input = (IEditorInput)element;
            String path = EclipseUtils.getFilePath(input);
            try {
                FileUtils.write((File)new File(path), (String)this.getDocument(null).get(), (String)"UTF-8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            super.doSaveDocument(monitor, element, document, overwrite);
        }
    }

    class XMLPartitioner
    extends FastPartitioner {
        XMLPartitioner() {
            super((IPartitionTokenScanner)new XMLPartitionScanner(), new String[]{"__xml_tag", "__xml_comment"});
        }
    }
}

