/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.editors.xml.bean;

import com.swtdesigner.SWTResourceManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.Image;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.gda.richbeans.editors.xml.bean.ColorManager;
import uk.ac.gda.richbeans.editors.xml.bean.IXMLColorConstants;
import uk.ac.gda.richbeans.editors.xml.bean.NonRuleBasedDamagerRepairer;
import uk.ac.gda.richbeans.editors.xml.bean.XMLDoubleClickStrategy;
import uk.ac.gda.richbeans.editors.xml.bean.XMLScanner;
import uk.ac.gda.richbeans.editors.xml.bean.XMLTagScanner;
import uk.ac.gda.util.schema.SchemaReader;

public class XMLConfiguration
extends SourceViewerConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(XMLConfiguration.class);
    private XMLDoubleClickStrategy doubleClickStrategy;
    private XMLTagScanner tagScanner;
    private XMLScanner scanner;
    private ColorManager colorManager;
    private SchemaReader schemaReader;
    private static Pattern END = Pattern.compile("^.*\\<\\/(.+)\\>.*$");
    private static Pattern SIBLING = Pattern.compile("^.*\\<(.+)\\>.*$");

    public XMLConfiguration(ColorManager colorManager, URL schemaUrl) throws Exception {
        this.colorManager = colorManager;
        try {
            if (schemaUrl != null) {
                this.schemaReader = new SchemaReader(schemaUrl);
            }
        }
        catch (NullPointerException nullPointerException) {
            logger.error("Cannot create Schema reader for " + schemaUrl);
        }
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__xml_comment", "__xml_tag"};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new XMLDoubleClickStrategy();
        }
        return this.doubleClickStrategy;
    }

    protected XMLScanner getXMLScanner() {
        if (this.scanner == null) {
            this.scanner = new XMLScanner(this.colorManager);
            this.scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(IXMLColorConstants.DEFAULT))));
        }
        return this.scanner;
    }

    protected XMLTagScanner getXMLTagScanner() {
        if (this.tagScanner == null) {
            this.tagScanner = new XMLTagScanner(this.colorManager);
            this.tagScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(IXMLColorConstants.TAG))));
        }
        return this.tagScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getXMLTagScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__xml_tag");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xml_tag");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getXMLScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        NonRuleBasedDamagerRepairer ndr = new NonRuleBasedDamagerRepairer(new TextAttribute(this.colorManager.getColor(IXMLColorConstants.XML_COMMENT)));
        reconciler.setDamager((IPresentationDamager)ndr, "__xml_comment");
        reconciler.setRepairer((IPresentationRepairer)ndr, "__xml_comment");
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.setContentAssistProcessor((IContentAssistProcessor)new XMLCompletionProcessor(), "__dftl_partition_content_type");
        assistant.setContentAssistProcessor((IContentAssistProcessor)new XMLCompletionProcessor(), "__xml_tag");
        assistant.setContentAssistProcessor((IContentAssistProcessor)new XMLCompletionProcessor(), "__xml_comment");
        assistant.enableAutoActivation(true);
        assistant.setAutoActivationDelay(1);
        return assistant;
    }

    public List<String> getParents(ITextViewer viewer, int offset) {
        try {
            ITypedRegion type = viewer.getDocument().getPartition(offset);
            String seg = viewer.getDocument().get(type.getOffset(), type.getLength());
            String clean = seg.trim().replace("\n", "");
            Matcher matcher = END.matcher(clean);
            if (matcher.matches()) {
                return Arrays.asList(matcher.group(1));
            }
            matcher = SIBLING.matcher(clean);
            if (matcher.matches()) {
                String sibling = matcher.group(1);
                return this.schemaReader != null ? this.schemaReader.getParents(sibling) : Collections.EMPTY_LIST;
            }
        }
        catch (Exception e) {
            logger.debug("Problem determining tag at position.", (Throwable)e);
            return null;
        }
        return null;
    }

    private void filterCurrentlyTyped(ITextViewer viewer, int offset, List<String> allTags) {
        try {
            ITypedRegion type = viewer.getDocument().getPartition(offset);
            String seg = viewer.getDocument().get(type.getOffset(), type.getLength());
            String frag = seg.substring(seg.indexOf("<") + 1, seg.indexOf(10)).trim();
            if (frag != null && !"".equals(frag)) {
                Iterator<String> it = allTags.iterator();
                while (it.hasNext()) {
                    String name = it.next();
                    if (name.startsWith(frag)) continue;
                    it.remove();
                }
            }
        }
        catch (Exception e) {
            logger.debug("Problem filtering tags.", (Throwable)e);
        }
    }

    private int getNumberCharactersTyped(ITextViewer viewer, int offset) {
        try {
            String c = viewer.getDocument().get(offset, 1);
            int chars = 0;
            while (!"<".equals(c)) {
                c = viewer.getDocument().get(offset - ++chars, 1);
            }
            return chars - 1;
        }
        catch (Exception e) {
            logger.debug("Problem filtering tags.", (Throwable)e);
            return 0;
        }
    }

    public class XMLCompletionProcessor
    implements IContentAssistProcessor {
        private final Image tagImage = SWTResourceManager.getImage(XMLConfiguration.class, "/icons/tag.png");
        private final char[] CHARS = new char[]{'<'};

        public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
            List<String> parents = XMLConfiguration.this.getParents(viewer, offset);
            ArrayList allTags = new ArrayList(31);
            if (XMLConfiguration.this.schemaReader != null) {
                try {
                    for (String par : parents) {
                        allTags.addAll(XMLConfiguration.this.schemaReader.getChildTags(par));
                    }
                }
                catch (Exception exception) {
                    return null;
                }
            }
            XMLConfiguration.this.filterCurrentlyTyped(viewer, offset, allTags);
            int pos = XMLConfiguration.this.getNumberCharactersTyped(viewer, offset);
            ICompletionProposal[] props = new ICompletionProposal[allTags.size()];
            int iTag = 0;
            for (String tag : allTags) {
                CompletionProposal prop = new CompletionProposal(String.valueOf(tag.substring(pos)) + "></" + tag + ">", offset, 0, tag.length() + 1 - pos, this.tagImage, String.valueOf(tag) + "></" + tag + ">", null, null);
                props[iTag] = prop;
                ++iTag;
            }
            return props;
        }

        public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
            return null;
        }

        public char[] getCompletionProposalAutoActivationCharacters() {
            return this.CHARS;
        }

        public char[] getContextInformationAutoActivationCharacters() {
            return null;
        }

        public IContextInformationValidator getContextInformationValidator() {
            return null;
        }

        public String getErrorMessage() {
            return null;
        }
    }
}

