/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.editors.xml;

import com.swtdesigner.SWTResourceManager;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.gda.beans.BeansFactory;
import uk.ac.gda.common.rcp.util.EclipseUtils;
import uk.ac.gda.richbeans.editors.DirtyContainer;
import uk.ac.gda.richbeans.editors.xml.bean.ColorManager;
import uk.ac.gda.richbeans.editors.xml.bean.XMLConfiguration;
import uk.ac.gda.richbeans.editors.xml.bean.XMLDocumentProvider;
import uk.ac.gda.util.beans.xml.XMLHelpers;

public class XMLBeanEditor
extends TextEditor {
    private static final Logger logger = LoggerFactory.getLogger(XMLBeanEditor.class);
    private ColorManager colorManager;
    private DirtyContainer container;
    private final URL mappingUrl;
    private final URL schemaUrl;
    private Object editingBean;
    private IDocumentListener documentListener;
    private boolean dirtyOveride = false;

    public XMLBeanEditor(DirtyContainer container, URL mappingUrl, URL schemaUrl, Object bean) throws Exception {
        this.container = container;
        this.mappingUrl = mappingUrl;
        this.schemaUrl = schemaUrl;
        this.editingBean = bean;
        this.colorManager = new ColorManager();
        this.setSourceViewerConfiguration(new XMLConfiguration(this.colorManager, schemaUrl));
        XMLDocumentProvider docProv = new XMLDocumentProvider();
        this.setDocumentProvider((IDocumentProvider)docProv);
    }

    public Object getEditingBean() {
        return this.editingBean;
    }

    public void setEditingBean(Object editingBean) {
        this.editingBean = editingBean;
    }

    public void createPartControl(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        parent.setLayout((Layout)gridLayout);
        super.createPartControl(parent);
        Control text = parent.getChildren()[0];
        text.setLayoutData((Object)new GridData(4, 4, true, true));
        final Composite messageContainer = new Composite(parent, 0);
        GridData gd_messageContainer = new GridData(16384, 0x1000000, true, false);
        messageContainer.setLayoutData((Object)gd_messageContainer);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 2;
        messageContainer.setLayout((Layout)gridLayout_1);
        Label label = new Label(messageContainer, 0);
        label.setImage(SWTResourceManager.getImage(XMLBeanEditor.class, "/icons/page_error.png"));
        Label messageLabel = new Label(messageContainer, 0);
        messageLabel.setText("Comment tags cannot be saved.");
        messageContainer.setVisible(false);
        this.documentListener = new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                IDocument doc = event.getDocument();
                try {
                    IRegion region = doc.getLineInformationOfOffset(event.getOffset());
                    String line = doc.get(region.getOffset(), region.getLength());
                    boolean comm = line.indexOf("<!--") > -1;
                    messageContainer.setVisible(comm);
                }
                catch (BadLocationException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        };
        this.getDocumentProvider().getDocument(null).addDocumentListener(this.documentListener);
    }

    public void dispose() {
        this.getDocumentProvider().getDocument(null).removeDocumentListener(this.documentListener);
        this.colorManager.dispose();
        super.dispose();
    }

    public boolean isDirty() {
        if (this.dirtyOveride) {
            return false;
        }
        this.container.setDirty(super.isDirty());
        return super.isDirty();
    }

    public void doSave(IProgressMonitor monitor) {
        block8: {
            final IFile file = this.getIFile();
            monitor.beginTask(file.getName(), 100);
            try {
                try {
                    this.xmlToBean();
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)new WorkspaceModifyOperation(){

                        protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                            try {
                                XMLHelpers.writeToXML((URL)XMLBeanEditor.this.mappingUrl, (Object)XMLBeanEditor.this.editingBean, (File)file.getLocation().toFile());
                                IFile ifile = XMLBeanEditor.this.getIFile();
                                if (ifile != null) {
                                    ifile.refreshLocal(0, null);
                                }
                            }
                            catch (Exception e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    });
                    this.container.setDirty(false);
                }
                catch (Exception e) {
                    try {
                        logger.debug(e.getMessage(), (Throwable)e);
                        MessageDialog.openError((Shell)this.getSite().getShell(), (String)"XML Validation Error", (String)("The XML is not valid and cannot be saved.\n\nError message:\n" + XMLBeanEditor.getSantitizedExceptionMessage(e.getMessage())));
                    }
                    catch (Throwable ne) {
                        logger.error(ne.getMessage(), ne);
                        break block8;
                    }
                    monitor.done();
                    return;
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    public IFile getIFile() {
        return EclipseUtils.getIFile(this.getEditorInput());
    }

    public static String getSantitizedExceptionMessage(String exceptionMessage) {
        if (exceptionMessage == null) {
            return null;
        }
        int index = exceptionMessage.indexOf(58);
        if (index > -1) {
            exceptionMessage = exceptionMessage.substring(index + 1);
        }
        return exceptionMessage;
    }

    public void beanToXML(List<String> privateFields) throws Exception {
        try {
            this.dirtyOveride = true;
            IDocument doc = this.getDocumentProvider().getDocument(null);
            StringWriter writer = new StringWriter();
            Object clone = BeansFactory.deepClone((Object)this.editingBean);
            if (privateFields != null) {
                for (String fieldName : privateFields) {
                    BeansFactory.setBeanValue((Object)clone, (String)fieldName, null);
                }
            }
            try {
                XMLHelpers.writeToXML((URL)this.mappingUrl, (Object)clone, (Writer)writer);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            doc.set(writer.toString());
        }
        catch (Throwable throwable) {
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    XMLBeanEditor.this.dirtyOveride = false;
                }
            });
            throw throwable;
        }
        this.getSite().getShell().getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
    }

    public void xmlToBean() throws Exception {
        IDocument doc = this.getDocumentProvider().getDocument(null);
        XMLHelpers.setFromXML((Object)this.editingBean, (URL)this.mappingUrl, (URL)this.schemaUrl, (String)doc.get());
    }
}

