/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.editors;

import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.IControlContentAdapter2;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;

public class StyledTextContentAdapter
implements IControlContentAdapter,
IControlContentAdapter2 {
    public String getControlContents(Control control) {
        return ((StyledText)control).getText();
    }

    public int getCursorPosition(Control control) {
        return ((StyledText)control).getCaretOffset();
    }

    public Rectangle getInsertionBounds(Control control) {
        StyledText text = (StyledText)control;
        Point caretOrigin = text.getLocationAtOffset(text.getCaretOffset());
        return new Rectangle(caretOrigin.x + text.getClientArea().x, caretOrigin.y + text.getClientArea().y + 3, 1, text.getLineHeight());
    }

    public void insertControlContents(Control control, String contents, int cursorPosition) {
        StyledText text = (StyledText)control;
        text.insert(contents);
        cursorPosition = Math.min(cursorPosition, contents.length());
        text.setCaretOffset(text.getCaretOffset() + cursorPosition);
    }

    public void setControlContents(Control control, String term, int cursorPosition) {
        String text = ((StyledText)control).getText();
        String after = text.substring(((StyledText)control).getCaretOffset(), text.length());
        text = text.substring(0, ((StyledText)control).getCaretOffset());
        int i = term.length();
        while (i > 0) {
            String subterm = term.substring(0, i);
            if (text.endsWith(subterm)) {
                term = term.substring(i, term.length());
                break;
            }
            --i;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(text);
        buf.append(term);
        int len = buf.length();
        buf.append(after);
        ((StyledText)control).setText(buf.toString());
        ((StyledText)control).setCaretOffset(len);
    }

    public void setCursorPosition(Control control, int index) {
        ((StyledText)control).setCaretOffset(index);
    }

    public Point getSelection(Control control) {
        return ((StyledText)control).getSelection();
    }

    public void setSelection(Control control, Point range) {
        ((StyledText)control).setSelection(range);
    }
}

