/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.editors;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.eclipse.core.commands.operations.IOperationApprover;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.operations.LinearUndoViolationUserApprover;
import org.eclipse.ui.operations.NonLocalUndoUserApprover;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import uk.ac.gda.common.rcp.util.EclipseUtils;
import uk.ac.gda.common.rcp.util.IStorageUtils;
import uk.ac.gda.richbeans.beans.BeanUI;
import uk.ac.gda.richbeans.editors.DirtyContainer;
import uk.ac.gda.richbeans.editors.RichBeanEditorPart;
import uk.ac.gda.richbeans.editors.xml.XMLBeanEditor;
import uk.ac.gda.util.beans.xml.URLResolver;
import uk.ac.gda.util.beans.xml.XMLHelpers;

public abstract class RichBeanMultiPageEditorPart
extends MultiPageEditorPart
implements DirtyContainer,
IReusableEditor {
    private boolean undoRegistered = false;
    private static final Logger logger;
    protected Object editingBean;
    protected RichBeanEditorPart richBeanEditor;
    protected XMLBeanEditor xmlEditor;
    protected String path;
    protected UndoActionHandler undoAction;
    protected RedoActionHandler redoAction;
    protected IUndoContext context;
    private boolean allowDirtyUpdates = true;
    private boolean isDirty = false;
    private boolean pageChangeProcessing = false;

    static {
        XMLHelpers.setUrlResolver((URLResolver)EclipseUtils.getUrlResolver());
        logger = LoggerFactory.getLogger(RichBeanMultiPageEditorPart.class);
    }

    public RichBeanMultiPageEditorPart() {
        this.setPartProperty("RichBeanEditorPart", "true");
    }

    public abstract Class<?> getBeanClass();

    public abstract URL getMappingUrl();

    public abstract URL getSchemaUrl();

    protected abstract RichBeanEditorPart getRichBeanEditorPart(String var1, Object var2);

    public void setInput(IEditorInput input) {
        try {
            this.assignInput(input);
            this.createBean();
            this.linkUI();
            IEditorReference[] refs = this.getSite().getPage().getEditorReferences();
            int i = 0;
            while (i < refs.length) {
                IEditorPart part;
                if (refs[i].getId().equals(this.getSite().getId()) && (part = refs[i].getEditor(false)) != this) {
                    this.getSite().getPage().closeEditor(part, true);
                }
                ++i;
            }
        }
        catch (Throwable th) {
            logger.error("Error setting input for editor from input " + input.getName(), th);
        }
    }

    protected void createBean() {
        try {
            if (this.getEditorInput() instanceof IStorageEditorInput) {
                IStorage storage = ((IStorageEditorInput)this.getEditorInput()).getStorage();
                InputSource source = new InputSource(IStorageUtils.getContents(storage));
                this.editingBean = XMLHelpers.createFromXML((URL)this.getMappingUrl(), this.getBeanClass(), (URL)this.getSchemaUrl(), (InputSource)source, (boolean)false);
            } else {
                this.editingBean = XMLHelpers.createFromXML((URL)this.getMappingUrl(), this.getBeanClass(), (URL)this.getSchemaUrl(), (String)this.path, (boolean)false);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected void createUndoRedoActions() {
        this.context = new ObjectUndoContext((Object)this);
        this.undoAction = new UndoActionHandler(this.getSite(), this.context);
        this.redoAction = new RedoActionHandler(this.getSite(), this.context);
        IOperationHistory history = OperationHistoryFactory.getOperationHistory();
        history.addOperationApprover((IOperationApprover)new NonLocalUndoUserApprover(this.context, (IEditorPart)this, new Object[]{this.getEditorInput()}, Object.class));
        history.addOperationApprover((IOperationApprover)new LinearUndoViolationUserApprover(this.context, (IWorkbenchPart)this));
    }

    protected void assignInput(IEditorInput input) {
        super.setInput(input);
        this.path = EclipseUtils.getFilePath(input);
        this.setPartName(input.getName());
        if (this.richBeanEditor != null) {
            try {
                this.pageChangeProcessing = false;
                this.richBeanEditor.setInput(input);
                this.richBeanEditor.setPath(this.path);
            }
            finally {
                this.pageChangeProcessing = true;
            }
        }
        if (this.xmlEditor != null) {
            this.xmlEditor.setInput(input);
        }
    }

    protected void linkUI() {
        if (this.richBeanEditor != null) {
            try {
                this.pageChangeProcessing = false;
                super.setActivePage(0);
                this.richBeanEditor.setEditingBean(this.editingBean);
                this.richBeanEditor.linkUI(false);
            }
            finally {
                this.pageChangeProcessing = true;
            }
        }
        if (this.xmlEditor != null) {
            this.xmlEditor.setEditingBean(this.editingBean);
        }
    }

    protected void createPages() {
        this.createUndoRedoActions();
        try {
            this.richBeanEditor = this.createPage0();
            this.xmlEditor = this.createPage1();
        }
        catch (Throwable th) {
            logger.error("Error creating pages for editor ", th);
        }
    }

    protected RichBeanEditorPart createPage0() {
        try {
            RichBeanEditorPart richBeanEditor = this.getRichBeanEditorPart(this.path, this.editingBean);
            richBeanEditor.setUndoableContext(this.context);
            int index = this.addPage((IEditorPart)richBeanEditor, this.getEditorInput());
            richBeanEditor.linkUI(false);
            this.setPageText(index, richBeanEditor.getRichEditorTabText());
            return richBeanEditor;
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)("Error creating " + this.richBeanEditor.getRichEditorTabText() + " for " + this.getClass().getName()), null, (IStatus)e.getStatus());
            return null;
        }
    }

    protected XMLBeanEditor createPage1() {
        try {
            XMLBeanEditor xmlEditor = new XMLBeanEditor(this, this.getMappingUrl(), this.getSchemaUrl(), this.editingBean);
            int index = this.addPage((IEditorPart)xmlEditor, this.getEditorInput());
            this.setPageText(index, "XML");
            return xmlEditor;
        }
        catch (PartInitException e) {
            logger.error(e.getMessage(), (Throwable)e);
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)("Error creating text editor for " + this.getClass().getName()), null, (IStatus)e.getStatus());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public boolean isDirty() {
        if (this.path == null) {
            return false;
        }
        return this.isDirty;
    }

    @Override
    public void setDirty(boolean isDirty) {
        if (!this.allowDirtyUpdates) {
            return;
        }
        this.isDirty = isDirty;
        this.firePropertyChange(257);
    }

    protected void initializePageSwitching() {
        super.initializePageSwitching();
        this.pageChangeProcessing = true;
    }

    protected void pageChange(int newPageIndex) {
        block20: {
            if (!this.pageChangeProcessing) {
                if (!this.undoRegistered) {
                    this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            RichBeanMultiPageEditorPart.this.setUIUndoRedo();
                        }
                    });
                }
                super.pageChange(newPageIndex);
                return;
            }
            if (newPageIndex == 1) {
                try {
                    this.setXMLUndoRedo();
                    BeanUI.uiToBean(this.richBeanEditor, this.editingBean);
                    this.xmlEditor.beanToXML(this.getPrivateXMLFields());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (newPageIndex == 0) {
                block18: {
                    try {
                        this.setUIUndoRedo();
                        this.xmlEditor.xmlToBean();
                    }
                    catch (Exception e) {
                        try {
                            logger.debug("XML Validation stack trace.", (Throwable)e);
                            boolean isOk = MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)"XML Validation Error", (String)("The XML is not valid.\n\nDo you want to continue to change screen and lose your edits?\n\nError message:\n" + XMLBeanEditor.getSantitizedExceptionMessage(e.getMessage())));
                            if (isOk) break block18;
                            try {
                                this.pageChangeProcessing = false;
                                super.setActivePage(1);
                            }
                            finally {
                                this.pageChangeProcessing = true;
                            }
                        }
                        catch (Throwable ne) {
                            ne.printStackTrace();
                        }
                    }
                }
                try {
                    try {
                        this.allowDirtyUpdates = false;
                        this.richBeanEditor.linkUI(true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.allowDirtyUpdates = true;
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    this.allowDirtyUpdates = true;
                    throw throwable;
                }
                this.allowDirtyUpdates = true;
            }
        }
        super.pageChange(newPageIndex);
    }

    protected void setUIUndoRedo() {
        IActionBars actionBars = this.getEditorSite().getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
        actionBars.updateActionBars();
        OperationHistoryFactory.getOperationHistory().dispose(this.context, true, true, false);
        this.undoRegistered = true;
    }

    protected void setXMLUndoRedo() {
        IActionBars actionBars = this.getEditorSite().getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), this.xmlEditor.getAction(ActionFactory.UNDO.getId()));
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), this.xmlEditor.getAction(ActionFactory.REDO.getId()));
        actionBars.updateActionBars();
        OperationHistoryFactory.getOperationHistory().dispose(this.context, true, true, false);
        this.undoRegistered = true;
    }

    public void doSaveAs() {
        IFile currentiFile = EclipseUtils.getIFile(this.getEditorInput());
        IFolder folder = currentiFile != null ? (IFolder)currentiFile.getParent() : null;
        FileDialog dialog = new FileDialog(this.getSite().getShell(), 8192);
        dialog.setText("Save as XML");
        dialog.setFilterExtensions(new String[]{"*.xml"});
        File currentFile = new File(this.path);
        dialog.setFilterPath(currentFile.getParentFile().getAbsolutePath());
        String newFile = dialog.open();
        if (newFile != null) {
            FileStoreEditorInput input;
            boolean ovr;
            if (!newFile.endsWith(".xml")) {
                newFile = String.valueOf(newFile) + ".xml";
            }
            if ((newFile = this.validateFileName(newFile)) == null) {
                return;
            }
            File file = new File(newFile);
            if (file.exists() && !(ovr = MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)"Confirm File Overwrite", (String)("The file '" + file.getName() + "' exists in '" + file.getParentFile().getName() + "'.\n\n" + "Would you like to overwrite it?")))) {
                return;
            }
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Cannot save file.", (String)("The file '" + file.getName() + "' cannot be created in '" + file.getParentFile().getName() + "'.\n\n" + e.getMessage()));
                return;
            }
            try {
                if (!this.confirmFileNameChange(currentFile, file)) {
                    file.delete();
                    return;
                }
            }
            catch (Exception ne) {
                logger.error("Cannot confirm name change", (Throwable)ne);
                return;
            }
            if (folder != null && folder.getLocation().toFile().equals(file.getParentFile())) {
                IFile ifile = folder.getFile(file.getName());
                try {
                    ifile.refreshLocal(0, null);
                }
                catch (CoreException e) {
                    logger.error("Cannot refresh " + ifile, (Throwable)e);
                }
                input = new FileEditorInput(ifile);
            } else {
                input = new FileStoreEditorInput(EFS.getLocalFileSystem().fromLocalFile(file));
            }
            this.assignInput((IEditorInput)input);
            this.doSave((IProgressMonitor)new NullProgressMonitor());
            this.setDirty(false);
        }
    }

    public void doSave(IProgressMonitor monitor) {
        int index = this.getActivePage();
        if (index == 0) {
            this.richBeanEditor.doSave(monitor);
        } else if (index == 1) {
            this.xmlEditor.doSave(monitor);
            try {
                try {
                    this.allowDirtyUpdates = false;
                    BeanUI.beanToUI(this.editingBean, this.richBeanEditor);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.allowDirtyUpdates = true;
                }
            }
            finally {
                this.allowDirtyUpdates = true;
            }
        }
    }

    protected boolean confirmFileNameChange(File oldName, File newName) throws Exception {
        return true;
    }

    protected String validateFileName(String newFile) {
        return newFile;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public RichBeanEditorPart getRichBeanEditor() {
        return this.richBeanEditor;
    }

    public List<String> getPrivateXMLFields() {
        return null;
    }

    public void dispose() {
        this.editingBean = null;
        this.richBeanEditor.dispose();
        this.richBeanEditor = null;
        super.dispose();
    }
}

