/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.editors;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.EditorPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.gda.beans.BeansFactory;
import uk.ac.gda.common.rcp.util.EclipseUtils;
import uk.ac.gda.richbeans.beans.BeanUI;
import uk.ac.gda.richbeans.beans.IExpressionWidget;
import uk.ac.gda.richbeans.beans.IFieldProvider;
import uk.ac.gda.richbeans.beans.IFieldWidget;
import uk.ac.gda.richbeans.editors.BeanExpressionManager;
import uk.ac.gda.richbeans.editors.DirtyContainer;
import uk.ac.gda.richbeans.editors.RichBeanEditorOperation;
import uk.ac.gda.richbeans.event.ValueEvent;
import uk.ac.gda.richbeans.event.ValueListener;
import uk.ac.gda.util.beans.xml.XMLHelpers;

public abstract class RichBeanEditorPart
extends EditorPart
implements ValueListener,
IReusableEditor,
IFieldProvider {
    private static final Logger logger = LoggerFactory.getLogger(RichBeanEditorPart.class);
    protected Object editingBean;
    protected Object previousUndoBean;
    protected final DirtyContainer dirtyContainer;
    protected String path;
    protected final URL mappingURL;
    private boolean undoStackActive = true;
    private boolean isDisposed = false;
    protected IUndoContext undoableContext;
    protected boolean addedListenersAndSwitchedOn = false;
    protected List<String> expressionFields;

    protected abstract String getRichEditorTabText();

    public RichBeanEditorPart(String path, URL mappingURL, DirtyContainer dirtyContainer, Object editingBean) {
        this.path = path;
        this.mappingURL = mappingURL;
        this.dirtyContainer = dirtyContainer;
        this.editingBean = editingBean;
        try {
            this.previousUndoBean = BeansFactory.deepClone((Object)editingBean);
        }
        catch (Exception e) {
            try {
                logger.error("Cannot clone editing bean.", (Throwable)e);
                this.previousUndoBean = editingBean.getClass().newInstance();
            }
            catch (Exception e1) {
                logger.error("Cannot instantiate editing bean.", (Throwable)e1);
            }
        }
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.path == null) {
            return;
        }
        File file = new File(this.path);
        monitor.beginTask(file.getName(), 100);
        try {
            try {
                this.getEditingBean();
                WorkspaceModifyOperation saveOp = new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                        try {
                            XMLHelpers.writeToXML((URL)RichBeanEditorPart.this.mappingURL, (Object)RichBeanEditorPart.this.editingBean, (String)RichBeanEditorPart.this.path);
                            IFile ifile = RichBeanEditorPart.this.getIFile();
                            if (ifile != null) {
                                ifile.refreshLocal(0, null);
                            }
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                };
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)saveOp);
                this.notifyFileSaved(file);
                this.dirtyContainer.setDirty(false);
            }
            catch (Exception e2) {
                logger.error("Cannot save file", (Throwable)e2);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void notifyFileSaved(File file) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        if (this.dirtyContainer != null) {
            this.dirtyContainer.setDirty(false);
        }
    }

    public IFile getIFile() {
        return EclipseUtils.getIFile(this.getEditorInput());
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
        if (input != null) {
            this.setPartName(input.getName());
        }
    }

    public Object getEditingBean() throws Exception {
        BeanUI.uiToBean(this, this.editingBean);
        return this.editingBean;
    }

    public String getPath() {
        return this.path;
    }

    protected final void setEditingBean(Object editingBean) {
        this.editingBean = editingBean;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setUndoableContext(IUndoContext context) {
        this.undoableContext = context;
    }

    @Override
    public void valueChangePerformed(ValueEvent e) {
        this.dirtyContainer.setDirty(true);
        this.recordUndoableEvent(e.getFieldName());
    }

    protected void recordUndoableEvent(String fieldName) {
        if (!this.isUndoStackActive()) {
            return;
        }
        try {
            if (Thread.currentThread() != this.getSite().getShell().getDisplay().getThread()) {
                return;
            }
            Object previousBean = BeansFactory.deepClone((Object)this.previousUndoBean);
            Object newBean = BeansFactory.deepClone((Object)this.editingBean);
            BeanUI.uiToBean(this, newBean);
            newBean = BeansFactory.deepClone((Object)newBean);
            if (this.previousUndoBean != null && this.previousUndoBean.equals(newBean)) {
                return;
            }
            RichBeanEditorOperation undoableOperation = new RichBeanEditorOperation(fieldName, previousBean, newBean, this);
            undoableOperation.addContext(this.undoableContext);
            OperationHistoryFactory.getOperationHistory().add((IUndoableOperation)undoableOperation);
            this.previousUndoBean = newBean;
            this.getEditorSite().getActionBars().updateActionBars();
        }
        catch (Exception e1) {
            logger.error("Unable to add event to stack " + this.editingBean.toString(), (Throwable)e1);
        }
    }

    @Override
    public String getValueListenerName() {
        return "DirtyListener";
    }

    public boolean isDirty() {
        if (this.path == null) {
            return false;
        }
        return this.dirtyContainer.isDirty();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void linkUI(boolean isPageChange) {
        try {
            BeanUI.switchState(this.editingBean, this, false);
            BeanUI.beanToUI(this.editingBean, this);
            BeanUI.switchState(this.editingBean, this, true);
            if (!this.addedListenersAndSwitchedOn) {
                BeanUI.addValueListener(this.editingBean, this, this);
                BeanUI.setBeanFields(this.editingBean, this);
                this.addedListenersAndSwitchedOn = true;
                BeanUI.notify(this.editingBean, this, new BeanUI.BeanProcessor(){

                    @Override
                    public void process(Map.Entry<Object, Object> prop, IFieldWidget box) throws Exception {
                        if (box instanceof IExpressionWidget) {
                            IExpressionWidget expressionBox = (IExpressionWidget)box;
                            BeanExpressionManager man = new BeanExpressionManager(expressionBox, RichBeanEditorPart.this);
                            man.setAllowedSymbols(RichBeanEditorPart.this.getExpressionFields());
                            expressionBox.setExpressionManager(man);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            logger.error("Cannot push values from bean to UI in linkUI()", (Throwable)e);
        }
    }

    protected List<String> getExpressionFields() throws Exception {
        if (this.expressionFields == null) {
            this.expressionFields = BeanUI.getEditingFields(this.editingBean, this);
        }
        return this.expressionFields;
    }

    @Override
    public IFieldWidget getField(String fieldName) throws Exception {
        return BeanUI.getFieldWiget(fieldName, this);
    }

    @Override
    public Object getFieldValue(String fieldName) throws Exception {
        return this.getField(fieldName).getValue();
    }

    public void dispose() {
        this.setDisposed(true);
        super.dispose();
        try {
            BeanUI.dispose(this.editingBean, this);
        }
        catch (Exception e) {
            logger.error("Cannot dispose parts as expected", (Throwable)e);
        }
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    public void setDisposed(boolean isDisposed) {
        this.isDisposed = isDisposed;
    }

    public boolean isUndoStackActive() {
        return this.undoStackActive;
    }

    public void setUndoStackActive(boolean undoStackActive) {
        this.undoStackActive = undoStackActive;
    }
}

