/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.editors;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Shell;
import uk.ac.gda.richbeans.beans.BeanUI;
import uk.ac.gda.richbeans.editors.RichBeanEditorPart;

public class RichBeanEditorOperation
extends AbstractOperation {
    protected Object undo;
    protected Object redo;
    protected RichBeanEditorPart uiObject;

    public RichBeanEditorOperation(String label, Object undo, Object redo, RichBeanEditorPart uiObject) {
        super(label != null ? label : "");
        this.undo = undo;
        this.redo = redo;
        this.uiObject = uiObject;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return Status.OK_STATUS;
    }

    public IStatus beanToUI(IProgressMonitor monitor, IAdaptable info, Object bean) throws ExecutionException {
        Shell shell = (Shell)info.getAdapter(Shell.class);
        shell.setRedraw(false);
        this.uiObject.setUndoStackActive(false);
        try {
            BeanUI.beanToUI(bean, this.uiObject);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.uiObject.setUndoStackActive(true);
            shell.setRedraw(true);
        }
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.beanToUI(monitor, info, this.redo);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.beanToUI(monitor, info, this.undo);
    }
}

