/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.editors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.nfunk.jep.ASTConstant;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.FunctionTable;
import org.nfunk.jep.JEP;
import org.nfunk.jep.Node;
import org.nfunk.jep.Operator;
import org.nfunk.jep.OperatorSet;

public class ExpressionUtils {
    private static JEP PARSER;
    private static List<String> OPERATORS;
    private static List<String> CONSTANTS;
    private static List<String> FUNCTIONS;
    private static List<String> FUNCTIONS_BRACKETS;

    private static JEP getParser() {
        if (PARSER == null) {
            PARSER = new JEP();
            PARSER.addStandardFunctions();
            PARSER.addStandardConstants();
            PARSER.setAllowUndeclared(true);
        }
        return PARSER;
    }

    public static final List<String> getOperators() {
        if (OPERATORS == null) {
            ArrayList<String> tmp = new ArrayList<String>(31);
            JEP jepParser = ExpressionUtils.getParser();
            OperatorSet ops = jepParser.getOperatorSet();
            Operator[] operatorArray = ops.getOperators();
            int n = operatorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Operator operator = operatorArray[n2];
                tmp.add(operator.getSymbol());
                ++n2;
            }
            OPERATORS = Collections.unmodifiableList(tmp);
        }
        return OPERATORS;
    }

    public static boolean isOperator(String posOp) {
        return ExpressionUtils.getOperators().contains(posOp);
    }

    public static final List<String> getConstants() {
        if (CONSTANTS == null) {
            ArrayList<String> tmp = new ArrayList<String>(31);
            JEP jepParser = ExpressionUtils.getParser();
            for (Object var : jepParser.getSymbolTable().keySet()) {
                tmp.add(var.toString());
            }
            CONSTANTS = Collections.unmodifiableList(tmp);
        }
        return CONSTANTS;
    }

    public static boolean isConstant(String posConst) {
        return ExpressionUtils.getConstants().contains(posConst);
    }

    public static String getLastTerm(String contents) {
        if (contents == null || "".equals(contents)) {
            return "";
        }
        for (String op : ExpressionUtils.getOperators()) {
            if (!contents.endsWith(op)) continue;
            return "";
        }
        if (contents.endsWith("(")) {
            return "";
        }
        try {
            JEP parser = ExpressionUtils.getParser();
            Node node = parser.parseExpression(contents);
            ArrayList<Node> last = new ArrayList<Node>(1);
            ExpressionUtils.getLastNode(node, last);
            Node lastNode = (Node)last.get(0);
            if (lastNode instanceof ASTVarNode) {
                String tempName = ((ASTVarNode)lastNode).getName();
                return tempName;
            }
            if (lastNode instanceof ASTConstant) {
                String tempName = ((ASTConstant)lastNode).getValue().toString();
                return tempName;
            }
        }
        catch (Exception exception) {
            return "";
        }
        return "";
    }

    private static void getLastNode(Node node, List<Node> last) {
        if (node.jjtGetNumChildren() < 1) {
            last.clear();
            last.add(node);
            return;
        }
        int i = 0;
        while (i < node.jjtGetNumChildren()) {
            Node c = node.jjtGetChild(i);
            ExpressionUtils.getLastNode(c, last);
            ++i;
        }
    }

    public static final List<String> getFunctions() {
        if (FUNCTIONS == null) {
            ArrayList<String> tmp1 = new ArrayList<String>(31);
            ArrayList<String> tmp2 = new ArrayList<String>(31);
            JEP jepParser = ExpressionUtils.getParser();
            FunctionTable table = jepParser.getFunctionTable();
            for (Object function : table.keySet()) {
                tmp1.add(function.toString());
                tmp2.add(String.valueOf(function.toString()) + "(");
            }
            FUNCTIONS = Collections.unmodifiableList(tmp1);
            FUNCTIONS_BRACKETS = Collections.unmodifiableList(tmp2);
        }
        return FUNCTIONS;
    }

    public static Collection<? extends String> getFunctionsWithOpeningBrackets() {
        ExpressionUtils.getFunctions();
        return FUNCTIONS_BRACKETS;
    }
}

