/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.editors;

import com.swtdesigner.SWTResourceManager;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import uk.ac.gda.richbeans.editors.ExpressionUtils;

public class ExpressionLabelProvider
extends LabelProvider
implements ILabelProvider {
    private Collection<String> fields;
    private static Image expressionImage;
    private static Image constantImage;
    private static Image operatorImage;
    private static Image functionImage;

    public ExpressionLabelProvider(Collection<String> fields) {
        this.fields = Collections.unmodifiableCollection(fields);
        if (expressionImage == null) {
            expressionImage = SWTResourceManager.getImage(ExpressionLabelProvider.class, "/icons/bullet_blue.png");
        }
        if (constantImage == null) {
            constantImage = SWTResourceManager.getImage(ExpressionLabelProvider.class, "/icons/bullet_black.png");
        }
        if (operatorImage == null) {
            operatorImage = SWTResourceManager.getImage(ExpressionLabelProvider.class, "/icons/bullet_purple.png");
        }
        if (functionImage == null) {
            functionImage = SWTResourceManager.getImage(ExpressionLabelProvider.class, "/icons/bullet_star.png");
        }
    }

    public String getText(Object element) {
        IContentProposal prop = (IContentProposal)element;
        String label = prop.getContent();
        return label;
    }

    public Image getImage(Object element) {
        IContentProposal prop = (IContentProposal)element;
        String label = prop.getContent();
        if (this.fields.contains(label)) {
            return expressionImage;
        }
        if (ExpressionUtils.getFunctionsWithOpeningBrackets().contains(label)) {
            return functionImage;
        }
        if (ExpressionUtils.getConstants().contains(label)) {
            return constantImage;
        }
        if (ExpressionUtils.getOperators().contains(label)) {
            return operatorImage;
        }
        return null;
    }
}

