/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.editors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.StyledText;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.JEP;
import org.nfunk.jep.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.gda.richbeans.beans.IExpressionManager;
import uk.ac.gda.richbeans.beans.IExpressionWidget;
import uk.ac.gda.richbeans.beans.IFieldProvider;
import uk.ac.gda.richbeans.beans.IFieldWidget;
import uk.ac.gda.richbeans.editors.ExpressionContentProposalProvider;
import uk.ac.gda.richbeans.editors.ExpressionLabelProvider;
import uk.ac.gda.richbeans.editors.StyledTextContentAdapter;
import uk.ac.gda.richbeans.event.ValueEvent;
import uk.ac.gda.richbeans.event.ValueListener;
import uk.ac.gda.util.list.SortNatural;

public class BeanExpressionManager
implements IExpressionManager,
ValueListener {
    private static final Logger logger = LoggerFactory.getLogger(BeanExpressionManager.class);
    private double value;
    private boolean expressionValid;
    private String expression;
    private IFieldProvider provider;
    private IExpressionWidget widget;
    private Collection<String> fields;
    private JEP jepParser;
    private List<IFieldWidget> precedents = new ArrayList<IFieldWidget>(7);
    private ExpressionContentProposalProvider proposalProvider;

    public BeanExpressionManager(IExpressionWidget widget, IFieldProvider prov) {
        this.widget = widget;
        this.provider = prov;
        this.jepParser = new JEP();
        this.jepParser.addStandardFunctions();
        this.jepParser.addStandardConstants();
        this.jepParser.setAllowUndeclared(false);
        this.jepParser.setImplicitMul(true);
    }

    @Override
    public double getExpressionValue() {
        return this.value;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    @Override
    public void setExpression(String expression) {
        this.expression = expression;
        try {
            if (expression == null) {
                this.value = Double.NaN;
                this.expressionValid = false;
            }
            this.value = this.calculateValue();
            this.expressionValid = !Double.isNaN(this.value) && !Double.isInfinite(this.value);
            this.updateListeners();
        }
        catch (Exception exception) {
            this.clearListeners();
            this.value = Double.NaN;
            this.expressionValid = false;
        }
    }

    private void updateListeners() throws Exception {
        this.clearListeners();
        if (!this.expressionValid) {
            return;
        }
        Node node = this.jepParser.parse(this.expression);
        this.parseNode(node, this.precedents);
        for (IFieldWidget wid : this.precedents) {
            wid.addValueListener(this);
        }
    }

    private void clearListeners() {
        for (IFieldWidget widget : this.precedents) {
            try {
                widget.removeValueListener(this);
            }
            catch (Throwable throwable) {}
        }
        this.precedents.clear();
    }

    @Override
    public void valueChangePerformed(ValueEvent e) {
        if (e.getFieldName() == null) {
            return;
        }
        this.jepParser.addVariable(e.getFieldName(), e.getDoubleValue());
        this.value = this.jepParser.getValue();
        this.widget.setExpressionValue(this.value);
    }

    private void parseNode(Node node, List<IFieldWidget> precedents) throws Exception {
        if (node instanceof ASTVarNode) {
            IFieldWidget widget = this.getWidget((ASTVarNode)node);
            if (widget != null) {
                precedents.add(widget);
            }
            return;
        }
        int i = 0;
        while (i < node.jjtGetNumChildren()) {
            Node c = node.jjtGetChild(i);
            this.parseNode(c, precedents);
            ++i;
        }
    }

    private IFieldWidget getWidget(ASTVarNode node) {
        try {
            return this.provider.getField(node.getName());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private double calculateValue() {
        for (String field : this.fields) {
            Object value;
            try {
                value = this.provider.getFieldValue(field);
            }
            catch (Exception exception) {
                continue;
            }
            if (!(value instanceof Number)) continue;
            this.jepParser.addVariable(field, ((Number)value).doubleValue());
        }
        this.jepParser.parseExpression(this.getExpression());
        return this.jepParser.getValue();
    }

    @Override
    public Collection<String> getAllowedSymbols() throws Exception {
        return this.fields;
    }

    @Override
    public void setAllowedSymbols(Collection<String> fs) throws Exception {
        HashSet<String> fieldSet = new HashSet<String>(fs);
        if (this.widget.getFieldName() != null) {
            fieldSet.remove(this.widget.getFieldName());
        }
        ArrayList<String> fieldList = new ArrayList<String>(fieldSet.size());
        fieldList.addAll(fieldSet);
        Collections.sort(fieldList, new SortNatural(false));
        this.fields = fieldList;
        String[] fieldsArray = this.fields.toArray(new String[this.fields.size()]);
        if (this.widget.getControl() instanceof StyledText) {
            if (this.proposalProvider == null) {
                this.proposalProvider = new ExpressionContentProposalProvider(fieldsArray, this.widget);
                ContentProposalAdapter adapter = new ContentProposalAdapter(this.widget.getControl(), (IControlContentAdapter)new StyledTextContentAdapter(), (IContentProposalProvider)this.proposalProvider, null, null);
                adapter.setLabelProvider((ILabelProvider)new ExpressionLabelProvider(this.fields));
                adapter.setPropagateKeys(true);
                adapter.setProposalAcceptanceStyle(2);
            } else {
                this.proposalProvider.setProposals(fieldsArray);
            }
        }
    }

    @Override
    public boolean isExpressionValid() {
        return this.expressionValid;
    }

    @Override
    public String getValueListenerName() {
        return String.valueOf(this.widget.getFieldName()) + " " + this.getClass().getName();
    }
}

