/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.dialog;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.gda.richbeans.beans.BeanUI;

public abstract class BeanDialog
extends Dialog {
    private static final Logger logger = LoggerFactory.getLogger(BeanDialog.class);
    protected Object bean;

    protected BeanDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(48);
    }

    public void create() {
        super.create();
        this.getShell().setText("Configure User Input");
    }

    public boolean close() {
        if (this.getReturnCode() == 0) {
            try {
                BeanUI.switchState(this.bean, (Object)this, false);
                BeanUI.uiToBean((Object)this, this.bean);
            }
            catch (Exception e) {
                logger.error("Cannot get " + this.bean + " from dialog!", (Throwable)e);
            }
        }
        return super.close();
    }

    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object bean) {
        try {
            this.bean = bean;
            BeanUI.beanToUI(bean, (Object)this);
            BeanUI.switchState(bean, (Object)this, true);
            BeanUI.fireValueListeners(bean, (Object)this);
        }
        catch (Exception e) {
            logger.error("Cannot send " + bean + " to dialog!", (Throwable)e);
        }
    }
}

