/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.wrappers;

import com.swtdesigner.SWTResourceManager;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.nfunk.jep.JEP;
import swing2swt.layout.BorderLayout;
import uk.ac.gda.richbeans.components.ButtonComposite;
import uk.ac.gda.richbeans.event.ValueEvent;

public class TextWrapper
extends ButtonComposite {
    protected static final Color BLUE = SWTResourceManager.getColor(9);
    protected static final Color RED = SWTResourceManager.getColor(3);
    protected static final Color BLACK = SWTResourceManager.getColor(2);
    protected static final Color DARK_RED = SWTResourceManager.getColor(4);
    private JEP jepParser;
    private TEXT_TYPE textType = TEXT_TYPE.FREE_TXT;
    protected Text text;
    private ModifyListener modifyListener;
    private Map<String, Object> expressionVariables;
    private boolean multiLineMode = false;

    public TEXT_TYPE getTextType() {
        return this.textType;
    }

    public void setTextType(TEXT_TYPE textType) {
        this.textType = textType;
    }

    public TextWrapper(Composite parent, int style) {
        super(parent, 0);
        this.setLayout(new BorderLayout());
        this.text = new Text((Composite)this, style);
        this.text.setLayoutData((Object)"Center");
        this.mainControl = this.text;
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Object newValue = TextWrapper.this.getValue();
                if (TextWrapper.this.textType == TEXT_TYPE.EXPRESSION) {
                    if (TextWrapper.this.jepParser == null) {
                        TextWrapper.this.jepParser = new JEP();
                        TextWrapper.this.jepParser.addStandardFunctions();
                        TextWrapper.this.jepParser.addStandardConstants();
                        TextWrapper.this.jepParser.setAllowUndeclared(true);
                        TextWrapper.this.jepParser.setImplicitMul(true);
                    }
                    try {
                        TextWrapper.this.jepParser.parse("" + newValue);
                        TextWrapper.this.text.setToolTipText("Expression has valid syntax. Variables have not been checked for existence.");
                        if (TextWrapper.this.expressionVariables != null && !TextWrapper.this.expressionVariables.isEmpty()) {
                            for (String varName : TextWrapper.this.expressionVariables.keySet()) {
                                TextWrapper.this.jepParser.addVariable(varName, TextWrapper.this.expressionVariables.get(varName));
                            }
                            TextWrapper.this.jepParser.parseExpression("" + newValue);
                            TextWrapper.this.text.setToolTipText("Expression value '" + TextWrapper.this.jepParser.getValue() + "'");
                        }
                        if (!BLUE.isDisposed()) {
                            TextWrapper.this.text.setForeground(BLUE);
                        }
                    }
                    catch (Throwable throwable) {
                        if (!RED.isDisposed()) {
                            TextWrapper.this.text.setForeground(RED);
                        }
                        TextWrapper.this.text.setToolTipText("Expression has invalid syntax");
                    }
                } else if (TextWrapper.this.textType == TEXT_TYPE.FILENAME) {
                    TextWrapper.this.jepParser = null;
                    String testString = newValue.toString().trim();
                    if (testString.contains(" ") || testString.startsWith("-") || testString.contains(";") || testString.contains("<") || testString.contains("\t") || testString.contains("'") || testString.contains("\"") || testString.contains("\\") || testString.contains("\n") || testString.contains("..")) {
                        if (!RED.isDisposed()) {
                            TextWrapper.this.text.setForeground(RED);
                        }
                        TextWrapper.this.text.setToolTipText("Expression has invalid syntax");
                    } else {
                        TextWrapper.this.text.setToolTipText("Enter a valid filename. Do NOT use spaces, commas, backslash etc.");
                        if (!BLACK.isDisposed()) {
                            TextWrapper.this.text.setForeground(BLACK);
                        }
                    }
                }
                ValueEvent evt = new ValueEvent(TextWrapper.this.text, TextWrapper.this.getFieldName());
                evt.setValue(newValue);
                TextWrapper.this.eventDelegate.notifyValueListeners(evt);
            }
        };
        this.text.addModifyListener(this.modifyListener);
    }

    public void setToolTipText(String text) {
        this.text.setToolTipText(text);
    }

    @Override
    public void dispose() {
        if (this.text != null && !this.text.isDisposed()) {
            this.text.removeModifyListener(this.modifyListener);
        }
        super.dispose();
    }

    @Override
    public Object getValue() {
        if (this.multiLineMode) {
            String[] sa = this.getText().split(this.text.getLineDelimiter());
            return Arrays.asList(sa);
        }
        return this.getText();
    }

    public String getText() {
        if (this.text.isDisposed()) {
            return null;
        }
        return this.text.getText();
    }

    @Override
    public void setValue(Object value) {
        if (this.isDisposed()) {
            return;
        }
        if (value instanceof List) {
            this.multiLineMode = true;
            List lines = (List)value;
            StringBuilder buf = new StringBuilder();
            for (Object line : lines) {
                buf.append(line.toString());
                buf.append(this.text.getLineDelimiter());
            }
            this.text.setText(buf.toString());
        } else {
            this.multiLineMode = false;
            this.text.setText(value != null ? value.toString() : "");
        }
    }

    protected void checkSubclass() {
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        this.setVisible(active);
    }

    public void setTextLimit(int i) {
        this.text.setTextLimit(i);
    }

    public void setExpressionVariables(Map<String, Object> vars) {
        this.expressionVariables = vars;
    }

    public static enum TEXT_TYPE {
        FREE_TXT,
        EXPRESSION,
        FILENAME;

    }
}

